/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.factory;

import java.io.File;
import java.util.Set;
import org.apache.directory.server.core.factory.PartitionFactory;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.impl.avl.AvlPartition;
import org.apache.directory.server.xdbm.impl.avl.AvlIndex;
import org.apache.directory.shared.ldap.model.name.Dn;

public class AvlPartitionFactory
implements PartitionFactory {
    public AvlPartition createPartition(String id, String suffix, int cacheSize, File workingDirectory) throws Exception {
        AvlPartition partition = new AvlPartition();
        partition.setId(id);
        partition.setSuffix(new Dn(suffix));
        partition.setCacheSize(500);
        partition.setPartitionPath(workingDirectory.toURI());
        return partition;
    }

    public void addIndex(Partition partition, String attributeId, int cacheSize) throws Exception {
        if (!(partition instanceof AvlPartition)) {
            throw new IllegalArgumentException("Partition must be a AvlPartition");
        }
        AvlPartition avlPartition = (AvlPartition)partition;
        Set indexedAttributes = avlPartition.getIndexedAttributes();
        AvlIndex index = new AvlIndex(attributeId);
        indexedAttributes.add(index);
        avlPartition.setIndexedAttributes(indexedAttributes);
    }
}

