/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.filtering;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.directory.server.core.filtering.EntryFilter;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.SearchingOperationContext;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.cursor.ClosureMonitor;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CursorList
implements EntryFilteringCursor {
    private final List<EntryFilteringCursor> list;
    private final int start;
    private final int end;
    private int index = -1;
    private SearchingOperationContext searchContext;
    private boolean closed;
    private static final Logger LOG = LoggerFactory.getLogger(CursorList.class);

    public CursorList(int start, List<EntryFilteringCursor> list, int end, SearchingOperationContext searchContext) {
        this.list = list != null ? list : Collections.emptyList();
        if (start < 0 || start > this.list.size()) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_02005_START_INDEX_OUT_OF_RANGE, start));
        }
        if (end < 0 || end > this.list.size()) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_02006_END_INDEX_OUT_OF_RANGE, end));
        }
        if (this.list.size() > 0 && start >= end) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_02007_START_INDEX_ABOVE_END_INDEX, start, end));
        }
        this.start = start;
        this.end = end;
        this.searchContext = searchContext;
    }

    public CursorList(List<EntryFilteringCursor> list, SearchingOperationContext searchContext) {
        this(0, list, list.size(), searchContext);
    }

    @Override
    public boolean available() {
        if (this.index >= 0 && this.index < this.end) {
            return this.list.get(this.index).available();
        }
        return false;
    }

    @Override
    public void before(Entry element) throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02008_LIST_MAY_BE_SORTED, new Object[0]));
    }

    @Override
    public void after(Entry element) throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02008_LIST_MAY_BE_SORTED, new Object[0]));
    }

    @Override
    public void beforeFirst() throws Exception {
        this.index = 0;
        this.list.get(this.index).beforeFirst();
    }

    @Override
    public void afterLast() throws Exception {
        this.index = this.end - 1;
        this.list.get(this.index).afterLast();
    }

    @Override
    public boolean first() throws Exception {
        if (this.list.size() > 0) {
            this.index = this.start;
            return this.list.get(this.index).first();
        }
        return false;
    }

    @Override
    public boolean last() throws Exception {
        if (this.list.size() > 0) {
            this.index = this.end - 1;
            return this.list.get(this.index).last();
        }
        return false;
    }

    @Override
    public boolean isFirst() throws Exception {
        return this.list.size() > 0 && this.index == this.start && this.list.get(this.index).first();
    }

    @Override
    public boolean isLast() throws Exception {
        return this.list.size() > 0 && this.index == this.end - 1 && this.list.get(this.index).last();
    }

    @Override
    public boolean isAfterLast() throws Exception {
        return this.index == this.end;
    }

    @Override
    public boolean isBeforeFirst() throws Exception {
        return this.index == -1;
    }

    @Override
    public boolean previous() throws Exception {
        if (this.index == -1) {
            return false;
        }
        if (this.index - 1 >= this.start) {
            if (this.index == this.end) {
                --this.index;
            }
            if (!this.list.get(this.index).previous()) {
                --this.index;
                if (this.index != -1) {
                    return this.list.get(this.index).previous();
                }
                return false;
            }
            return true;
        }
        if (this.index <= this.start) {
            if (!this.list.get(this.index).previous()) {
                this.index = -1;
                return false;
            }
            return true;
        }
        if (this.list.size() <= 0) {
            this.index = -1;
        }
        return false;
    }

    @Override
    public boolean next() throws Exception {
        if (this.list.size() > 0 && this.index == -1) {
            this.index = this.start;
            return this.list.get(this.index).next();
        }
        if (this.list.size() > 0 && this.index + 1 < this.end) {
            if (!this.list.get(this.index).next()) {
                ++this.index;
                if (this.index < this.end) {
                    return this.list.get(this.index).next();
                }
                return false;
            }
            return true;
        }
        if (this.list.size() > 0 && this.index + 1 == this.end) {
            if (!this.list.get(this.index).next()) {
                ++this.index;
                return false;
            }
            return true;
        }
        if (this.list.size() <= 0) {
            this.index = this.end;
        }
        return false;
    }

    @Override
    public Entry get() throws Exception {
        if (this.index < this.start || this.index >= this.end) {
            throw new IOException(I18n.err(I18n.ERR_02009_CURSOR_NOT_POSITIONED, new Object[0]));
        }
        if (this.list.get(this.index).available()) {
            return (Entry)this.list.get(this.index).get();
        }
        throw new InvalidCursorPositionException();
    }

    @Override
    public boolean addEntryFilter(EntryFilter filter) {
        for (EntryFilteringCursor efc : this.list) {
            efc.addEntryFilter(filter);
        }
        return true;
    }

    @Override
    public List<EntryFilter> getEntryFilters() {
        throw new UnsupportedOperationException("CursorList doesn't support this operation");
    }

    @Override
    public SearchingOperationContext getOperationContext() {
        return this.searchContext;
    }

    @Override
    public boolean isAbandoned() {
        return this.getOperationContext().isAbandoned();
    }

    @Override
    public boolean removeEntryFilter(EntryFilter filter) {
        return false;
    }

    @Override
    public void setAbandoned(boolean abandoned) {
        this.getOperationContext().setAbandoned(abandoned);
        if (abandoned) {
            LOG.info("Cursor has been abandoned.");
        }
    }

    @Override
    public void close() throws Exception {
        this.close(null);
    }

    @Override
    public void close(Exception reason) throws Exception {
        this.closed = true;
        for (EntryFilteringCursor c : this.list) {
            try {
                if (reason != null) {
                    c.close(reason);
                    continue;
                }
                c.close();
            }
            catch (Exception e) {
                LOG.warn("Failed to close the cursor");
            }
        }
    }

    @Override
    public boolean isClosed() throws Exception {
        return this.closed;
    }

    @Override
    public Iterator<Entry> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClosureMonitor(ClosureMonitor monitor) {
        for (EntryFilteringCursor c : this.list) {
            c.setClosureMonitor(monitor);
        }
    }
}

