/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.interceptor.context.AbstractOperationContext;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookupOperationContext
extends AbstractOperationContext {
    private static final String[] EMPTY = new String[0];
    private List<String> attrsId = new ArrayList<String>();
    private Boolean allOperational;
    private Boolean allUser;
    private Boolean noAttribute;

    public LookupOperationContext(CoreSession session) {
        super(session);
    }

    public LookupOperationContext(CoreSession session, Dn dn) {
        super(session, dn);
    }

    public LookupOperationContext(CoreSession session, String[] attrsId) {
        super(session);
        this.setAttrsId(attrsId);
    }

    public LookupOperationContext(CoreSession session, Dn dn, String[] attrsId) {
        super(session, dn);
        this.setAttrsId(attrsId);
    }

    public String[] getAttrsIdArray() {
        if (this.attrsId == null || this.attrsId.size() == 0) {
            return EMPTY;
        }
        String[] attrs = new String[this.attrsId.size()];
        return this.attrsId.toArray(attrs);
    }

    public void setAttrsId(String[] attrsId) {
        if (attrsId != null && attrsId.length > 0) {
            this.attrsId = new ArrayList<String>(Arrays.asList(attrsId));
            for (String id : this.attrsId) {
                if (id.equals("+")) {
                    this.allOperational = true;
                    continue;
                }
                if (id.equals("*")) {
                    this.allUser = true;
                    continue;
                }
                if (!id.equals("1.1")) continue;
                this.noAttribute = true;
                this.allOperational = null;
                this.allUser = null;
                break;
            }
            if (this.allOperational != null && this.allOperational.booleanValue()) {
                this.attrsId.remove("+");
            }
            if (this.allUser != null && this.allUser.booleanValue()) {
                this.attrsId.remove("*");
            }
            if (this.noAttribute != null) {
                this.attrsId.clear();
            }
        }
    }

    public void addAttrsId(String attrId) {
        if (this.noAttribute == null) {
            if (attrId.equals("1.1")) {
                this.noAttribute = true;
                if (this.attrsId != null) {
                    this.attrsId.clear();
                }
                return;
            }
            if (attrId.equals("*")) {
                this.allUser = true;
                return;
            }
            if (attrId.equals("+")) {
                this.allOperational = true;
                return;
            }
            if (this.attrsId == null) {
                this.attrsId = new ArrayList<String>();
            }
            this.attrsId.add(attrId);
        }
    }

    public List<String> getAttrsId() {
        return this.attrsId;
    }

    public boolean hasAllUser() {
        return this.allUser != null && this.allUser != false;
    }

    public boolean hasAllOperational() {
        return this.allOperational != null && this.allOperational != false;
    }

    public boolean hasNoAttribute() {
        return this.noAttribute != null;
    }

    @Override
    public String getName() {
        return "Lookup";
    }

    public String toString() {
        return "LookupContext for Dn '" + this.getDn().getName() + "'" + (this.attrsId != null ? ", attributes : <" + Strings.listToString(this.attrsId) + ">" : "");
    }
}

