/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.util.Iterator;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.cursor.ClosureMonitor;
import org.apache.directory.shared.ldap.model.cursor.Cursor;
import org.apache.directory.shared.ldap.model.cursor.CursorIterator;
import org.apache.directory.shared.ldap.model.entry.Entry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerEntryCursorAdaptor<ID>
implements Cursor<Entry> {
    private final BTreePartition<ID> db;
    private final IndexCursor<ID, Entry, ID> indexCursor;

    public ServerEntryCursorAdaptor(BTreePartition<ID> db, IndexCursor<ID, Entry, ID> indexCursor) {
        this.db = db;
        this.indexCursor = indexCursor;
    }

    @Override
    public void after(Entry element) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void afterLast() throws Exception {
        this.indexCursor.afterLast();
    }

    @Override
    public boolean available() {
        return this.indexCursor.available();
    }

    @Override
    public void before(Entry element) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void beforeFirst() throws Exception {
        this.indexCursor.beforeFirst();
    }

    @Override
    public final void setClosureMonitor(ClosureMonitor monitor) {
        this.indexCursor.setClosureMonitor(monitor);
    }

    @Override
    public void close() throws Exception {
        this.indexCursor.close();
    }

    @Override
    public void close(Exception e) throws Exception {
        this.indexCursor.close(e);
    }

    @Override
    public boolean first() throws Exception {
        return this.indexCursor.first();
    }

    @Override
    public Entry get() throws Exception {
        IndexEntry indexEntry = (IndexEntry)this.indexCursor.get();
        if (indexEntry.getObject() == null) {
            indexEntry.setObject(this.db.lookup(indexEntry.getId()));
        }
        return (Entry)indexEntry.getObject();
    }

    @Override
    public boolean isClosed() throws Exception {
        return this.indexCursor.isClosed();
    }

    @Override
    public boolean last() throws Exception {
        return this.indexCursor.last();
    }

    @Override
    public boolean next() throws Exception {
        return this.indexCursor.next();
    }

    @Override
    public boolean previous() throws Exception {
        return this.indexCursor.previous();
    }

    @Override
    public Iterator<Entry> iterator() {
        return new CursorIterator<Entry>(this);
    }

    @Override
    public boolean isAfterLast() throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("isAfterLast()")));
    }

    @Override
    public boolean isBeforeFirst() throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("isBeforeFirst()")));
    }

    @Override
    public boolean isFirst() throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("isFirst()")));
    }

    @Override
    public boolean isLast() throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("isLast()")));
    }
}

