/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmStore;
import org.apache.directory.server.core.partition.impl.xdbm.AbstractXdbmPartition;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.search.impl.CursorBuilder;
import org.apache.directory.server.xdbm.search.impl.DefaultOptimizer;
import org.apache.directory.server.xdbm.search.impl.DefaultSearchEngine;
import org.apache.directory.server.xdbm.search.impl.EvaluatorBuilder;
import org.apache.directory.server.xdbm.search.impl.NoOpOptimizer;
import org.apache.directory.shared.ldap.model.entry.Entry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbmPartition
extends AbstractXdbmPartition<Long> {
    public JdbmPartition() {
        super(new JdbmStore<Entry>());
    }

    @Override
    protected void doInit() throws Exception {
        this.store.setPartitionPath(this.getPartitionPath());
        EvaluatorBuilder evaluatorBuilder = new EvaluatorBuilder(this.store, this.schemaManager);
        CursorBuilder cursorBuilder = new CursorBuilder(this.store, evaluatorBuilder);
        this.optimizer = !this.optimizerEnabled ? new NoOpOptimizer() : new DefaultOptimizer(this.store);
        this.searchEngine = new DefaultSearchEngine(this.store, cursorBuilder, evaluatorBuilder, this.optimizer);
        this.store.setCacheSize(this.cacheSize);
        this.store.setId(this.id);
        this.suffix.apply(this.schemaManager);
        this.store.setSuffixDn(this.suffix);
        this.store.setPartitionPath(this.getPartitionPath());
        for (Index index : this.getIndexedAttributes()) {
            String oid = this.schemaManager.getAttributeTypeRegistry().getOidByName(index.getAttributeId());
            if (!index.getAttributeId().equals(oid)) {
                index.setAttributeId(oid);
            }
            this.store.addIndex(index);
        }
        this.store.init(this.schemaManager);
    }

    public Index<String, Entry, Long> getObjectClassIndex() {
        return this.store.getObjectClassIndex();
    }

    public Index<String, Entry, Long> getEntryCsnIndex() {
        return this.store.getEntryCsnIndex();
    }

    public Index<String, Entry, Long> getEntryUuidIndex() {
        return this.store.getEntryUuidIndex();
    }
}

