/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.HashSet;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.schema.SchemaPartition;
import org.apache.directory.server.core.schema.SchemaService;
import org.apache.directory.shared.ldap.model.constants.SchemaConstants;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultAttribute;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.DITContentRule;
import org.apache.directory.shared.ldap.model.schema.DITStructureRule;
import org.apache.directory.shared.ldap.model.schema.LdapComparator;
import org.apache.directory.shared.ldap.model.schema.LdapSyntax;
import org.apache.directory.shared.ldap.model.schema.MatchingRule;
import org.apache.directory.shared.ldap.model.schema.MatchingRuleUse;
import org.apache.directory.shared.ldap.model.schema.NameForm;
import org.apache.directory.shared.ldap.model.schema.Normalizer;
import org.apache.directory.shared.ldap.model.schema.ObjectClass;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.SchemaUtils;
import org.apache.directory.shared.ldap.model.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.model.schema.registries.NormalizerRegistry;

public class DefaultSchemaService
implements SchemaService {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private Entry schemaSubentry;
    private final Object lock = new Object();
    private SchemaPartition schemaPartition;
    private Dn schemaModificationAttributesDn;
    private Object schemaSubentrLock = new Object();

    public DefaultSchemaService() throws Exception {
        this.schemaPartition = new SchemaPartition();
    }

    public boolean isSchemaSubentry(Dn dn) throws LdapException {
        return dn.getNormName().equals("2.5.4.3=schema");
    }

    public final SchemaManager getSchemaManager() {
        return this.schemaPartition.getSchemaManager();
    }

    public SchemaPartition getSchemaPartition() {
        return this.schemaPartition;
    }

    private Attribute generateComparators() throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(this.getSchemaManager().lookupAttributeTypeRegistry("comparators"));
        for (LdapComparator comparator : this.getSchemaManager().getComparatorRegistry()) {
            attr.add(SchemaUtils.render(comparator));
        }
        return attr;
    }

    private Attribute generateNormalizers() throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(this.getSchemaManager().getAttributeType("normalizers"));
        NormalizerRegistry nr = this.getSchemaManager().getNormalizerRegistry();
        for (Normalizer normalizer : nr) {
            attr.add(SchemaUtils.render(normalizer));
        }
        return attr;
    }

    private Attribute generateSyntaxCheckers() throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(this.getSchemaManager().getAttributeType("syntaxCheckers"));
        for (SyntaxChecker syntaxChecker : this.getSchemaManager().getSyntaxCheckerRegistry()) {
            attr.add(SchemaUtils.render(syntaxChecker));
        }
        return attr;
    }

    private Attribute generateObjectClasses() throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(this.getSchemaManager().getAttributeType("objectClasses"));
        for (ObjectClass objectClass : this.getSchemaManager().getObjectClassRegistry()) {
            attr.add(SchemaUtils.render(objectClass).toString());
        }
        return attr;
    }

    private Attribute generateAttributeTypes() throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(this.getSchemaManager().getAttributeType("attributeTypes"));
        for (AttributeType attributeType : this.getSchemaManager().getAttributeTypeRegistry()) {
            attr.add(SchemaUtils.render(attributeType).toString());
        }
        return attr;
    }

    private Attribute generateMatchingRules() throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(this.getSchemaManager().getAttributeType("matchingRules"));
        for (MatchingRule matchingRule : this.getSchemaManager().getMatchingRuleRegistry()) {
            attr.add(SchemaUtils.render(matchingRule).toString());
        }
        return attr;
    }

    private Attribute generateMatchingRuleUses() throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(this.getSchemaManager().getAttributeType("matchingRuleUse"));
        for (MatchingRuleUse matchingRuleUse : this.getSchemaManager().getMatchingRuleUseRegistry()) {
            attr.add(SchemaUtils.render(matchingRuleUse).toString());
        }
        return attr;
    }

    private Attribute generateSyntaxes() throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(this.getSchemaManager().getAttributeType("ldapSyntaxes"));
        for (LdapSyntax syntax : this.getSchemaManager().getLdapSyntaxRegistry()) {
            attr.add(SchemaUtils.render(syntax).toString());
        }
        return attr;
    }

    private Attribute generateDitContextRules() throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(this.getSchemaManager().getAttributeType("ditContentRules"));
        for (DITContentRule ditContentRule : this.getSchemaManager().getDITContentRuleRegistry()) {
            attr.add(SchemaUtils.render(ditContentRule).toString());
        }
        return attr;
    }

    private Attribute generateDitStructureRules() throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(this.getSchemaManager().getAttributeType("ditStructureRules"));
        for (DITStructureRule ditStructureRule : this.getSchemaManager().getDITStructureRuleRegistry()) {
            attr.add(SchemaUtils.render(ditStructureRule).toString());
        }
        return attr;
    }

    private Attribute generateNameForms() throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(this.getSchemaManager().getAttributeType("nameForms"));
        for (NameForm nameForm : this.getSchemaManager().getNameFormRegistry()) {
            attr.add(SchemaUtils.render(nameForm).toString());
        }
        return attr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateSchemaSubentry(Entry mods) throws LdapException {
        DefaultEntry attrs = new DefaultEntry(this.getSchemaManager(), mods.getDn());
        attrs.put("objectClass", "top", "subschema", "subentry", "apacheSubschema");
        attrs.put("cn", "schema");
        attrs.put(this.generateComparators());
        attrs.put(this.generateNormalizers());
        attrs.put(this.generateSyntaxCheckers());
        attrs.put(this.generateObjectClasses());
        attrs.put(this.generateAttributeTypes());
        attrs.put(this.generateMatchingRules());
        attrs.put(this.generateMatchingRuleUses());
        attrs.put(this.generateSyntaxes());
        attrs.put(this.generateDitContextRules());
        attrs.put(this.generateDitStructureRules());
        attrs.put(this.generateNameForms());
        attrs.put("subtreeSpecification", "{}");
        Attribute createTimestamp = mods.get("createTimestamp");
        attrs.put("createTimestamp", createTimestamp.get());
        attrs.put("creatorsName", "uid=admin,ou=system");
        Attribute schemaModifyTimestamp = mods.get("schemaModifyTimestamp");
        attrs.put("modifyTimestamp", schemaModifyTimestamp.get());
        Attribute schemaModifiersName = mods.get("schemaModifiersName");
        attrs.put("modifiersName", schemaModifiersName.get());
        Object object = this.lock;
        synchronized (object) {
            this.schemaSubentry = attrs;
        }
    }

    private void addAttribute(Entry attrs, String id) throws LdapException {
        Attribute attr = this.schemaSubentry.get(id);
        if (attr != null) {
            attrs.put(attr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getSubschemaEntryImmutable() throws LdapException {
        Object object = this.schemaSubentrLock;
        synchronized (object) {
            if (this.schemaSubentry == null) {
                this.generateSchemaSubentry(this.schemaPartition.lookup(new LookupOperationContext(null, this.schemaModificationAttributesDn)));
            }
            return this.schemaSubentry.clone();
        }
    }

    public void initialize() throws LdapException {
        try {
            this.schemaModificationAttributesDn = new Dn(this.getSchemaManager(), "cn=schemaModifications,ou=schema");
        }
        catch (LdapException e) {
            throw new RuntimeException(e);
        }
    }

    public Entry getSubschemaEntryCloned() throws LdapException {
        if (this.schemaSubentry == null) {
            this.generateSchemaSubentry(this.schemaPartition.lookup(new LookupOperationContext(null, this.schemaModificationAttributesDn)));
        }
        return this.schemaSubentry.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getSubschemaEntry(String[] ids) throws LdapException {
        if (ids == null) {
            ids = EMPTY_STRING_ARRAY;
        }
        HashSet<String> setOids = new HashSet<String>();
        DefaultEntry attrs = new DefaultEntry(this.getSchemaManager(), Dn.ROOT_DSE);
        boolean returnAllOperationalAttributes = false;
        Object object = this.lock;
        synchronized (object) {
            Entry mods = this.schemaPartition.lookup(new LookupOperationContext(null, this.schemaModificationAttributesDn, SchemaConstants.ALL_ATTRIBUTES_ARRAY));
            this.generateSchemaSubentry(mods);
            for (String id : ids) {
                if ("+".equals(id)) {
                    returnAllOperationalAttributes = true;
                    continue;
                }
                if ("*".equals(id)) {
                    setOids.add(id);
                    continue;
                }
                setOids.add(this.getSchemaManager().getAttributeTypeRegistry().getOidByName(id));
            }
            if (returnAllOperationalAttributes || setOids.contains("1.3.6.1.4.1.18060.0.4.1.2.32")) {
                this.addAttribute(attrs, "comparators");
            }
            if (returnAllOperationalAttributes || setOids.contains("1.3.6.1.4.1.18060.0.4.1.2.33")) {
                this.addAttribute(attrs, "normalizers");
            }
            if (returnAllOperationalAttributes || setOids.contains("1.3.6.1.4.1.18060.0.4.1.2.34")) {
                this.addAttribute(attrs, "syntaxCheckers");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.6")) {
                this.addAttribute(attrs, "objectClasses");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.5")) {
                this.addAttribute(attrs, "attributeTypes");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.4")) {
                this.addAttribute(attrs, "matchingRules");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.8")) {
                this.addAttribute(attrs, "matchingRuleUse");
            }
            if (returnAllOperationalAttributes || setOids.contains("1.3.6.1.4.1.1466.101.120.16")) {
                this.addAttribute(attrs, "ldapSyntaxes");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.2")) {
                this.addAttribute(attrs, "ditContentRules");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.1")) {
                this.addAttribute(attrs, "ditStructureRules");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.7")) {
                this.addAttribute(attrs, "nameForms");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.18.6")) {
                this.addAttribute(attrs, "subtreeSpecification");
            }
            int minSetSize = 0;
            if (setOids.contains("+")) {
                ++minSetSize;
            }
            if (setOids.contains("*")) {
                ++minSetSize;
            }
            if (setOids.contains("2.16.840.1.113730.3.1.34")) {
                ++minSetSize;
            }
            if (setOids.contains("*") || setOids.contains("2.5.4.0") || setOids.size() == minSetSize) {
                this.addAttribute(attrs, "objectClass");
            }
            if (setOids.contains("*") || setOids.contains("2.5.4.3") || setOids.size() == minSetSize) {
                this.addAttribute(attrs, "cn");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.18.1")) {
                this.addAttribute(attrs, "createTimestamp");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.18.3")) {
                this.addAttribute(attrs, "creatorsName");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.18.2")) {
                this.addAttribute(attrs, "modifyTimestamp");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.18.4")) {
                this.addAttribute(attrs, "modifiersName");
            }
        }
        return attrs;
    }
}

