/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.ArrayList;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.partition.AbstractPartition;
import org.apache.directory.server.core.partition.ByPassConstants;
import org.apache.directory.server.core.partition.NullPartition;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.schema.registries.synchronizers.RegistrySynchronizerAdaptor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.constants.SchemaConstants;
import org.apache.directory.shared.ldap.model.entry.DefaultAttribute;
import org.apache.directory.shared.ldap.model.entry.DefaultModification;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.ModificationOperation;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.SchemaUtils;
import org.apache.directory.shared.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaPartition
extends AbstractPartition {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaPartition.class);
    private static final String ID = "schema";
    private Partition wrapped = new NullPartition();
    private RegistrySynchronizerAdaptor synchronizer;
    private static Dn schemaModificationDn;
    private static Dn schemaDn;

    public void setWrappedPartition(Partition wrapped) {
        if (this.isInitialized()) {
            throw new IllegalStateException(I18n.err(I18n.ERR_429, new Object[0]));
        }
        this.wrapped = wrapped;
    }

    public Partition getWrappedPartition() {
        return this.wrapped;
    }

    public String getId() {
        return ID;
    }

    public void setId(String id) {
        LOG.warn("This partition's ID is fixed: {}", (Object)ID);
    }

    public Dn getSuffix() {
        return this.wrapped.getSuffix();
    }

    public void setSuffix(Dn suffix) {
        LOG.warn("This partition's suffix is fixed: {}", (Object)"ou=schema");
    }

    public void sync() throws Exception {
        this.wrapped.sync();
    }

    protected void doInit() throws Exception {
        schemaDn = new Dn(this.schemaManager, "ou=schema");
        this.wrapped.setId(ID);
        this.wrapped.setSuffix(schemaDn);
        this.wrapped.setSchemaManager(this.schemaManager);
        try {
            this.wrapped.initialize();
            this.synchronizer = new RegistrySynchronizerAdaptor(this.schemaManager);
            if (this.wrapped instanceof NullPartition) {
                LOG.warn("BYPASSING CRITICAL SCHEMA PROCESSING CODE DURING HEAVY DEV.  PLEASE REMOVE THIS CONDITION BY USING A VALID SCHEMA PARTITION!!!");
                return;
            }
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_90, new Object[0]), e);
            throw new RuntimeException(e);
        }
        schemaModificationDn = new Dn(this.schemaManager, "cn=schemaModifications,ou=schema");
    }

    protected void doDestroy() {
        try {
            this.wrapped.destroy();
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_91, new Object[0]), e);
            throw new RuntimeException(e);
        }
    }

    public void add(AddOperationContext addContext) throws LdapException {
        this.synchronizer.add(addContext);
        this.wrapped.add(addContext);
        this.updateSchemaModificationAttributes(addContext);
    }

    public void bind(BindOperationContext bindContext) throws LdapException {
        this.wrapped.bind(bindContext);
    }

    public void delete(DeleteOperationContext deleteContext) throws LdapException {
        boolean cascade = deleteContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1");
        this.synchronizer.delete(deleteContext, cascade);
        this.wrapped.delete(deleteContext);
        this.updateSchemaModificationAttributes(deleteContext);
    }

    public EntryFilteringCursor list(ListOperationContext listContext) throws LdapException {
        return this.wrapped.list(listContext);
    }

    public boolean hasEntry(EntryOperationContext hasEntryContext) throws LdapException {
        return this.wrapped.hasEntry(hasEntryContext);
    }

    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        boolean cascade;
        Entry targetEntry;
        boolean hasModification;
        Entry entry = modifyContext.getEntry();
        if (entry == null) {
            LookupOperationContext lookupCtx = new LookupOperationContext(modifyContext.getSession(), modifyContext.getDn());
            entry = this.wrapped.lookup(lookupCtx);
        }
        if (hasModification = this.synchronizer.modify(modifyContext, targetEntry = SchemaUtils.getTargetEntry(modifyContext.getModItems(), entry), cascade = modifyContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1"))) {
            this.wrapped.modify(modifyContext);
        }
        if (!modifyContext.getDn().equals(schemaModificationDn)) {
            this.updateSchemaModificationAttributes(modifyContext);
        }
    }

    public void move(MoveOperationContext moveContext) throws LdapException {
        boolean cascade = moveContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1");
        Entry entry = moveContext.lookup(moveContext.getDn(), ByPassConstants.LOOKUP_BYPASS, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        this.synchronizer.move(moveContext, entry, cascade);
        this.wrapped.move(moveContext);
        this.updateSchemaModificationAttributes(moveContext);
    }

    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        boolean cascade = moveAndRenameContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1");
        Entry entry = moveAndRenameContext.lookup(moveAndRenameContext.getDn(), ByPassConstants.LOOKUP_BYPASS, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        this.synchronizer.moveAndRename(moveAndRenameContext, entry, cascade);
        this.wrapped.moveAndRename(moveAndRenameContext);
        this.updateSchemaModificationAttributes(moveAndRenameContext);
    }

    public void rename(RenameOperationContext renameContext) throws LdapException {
        boolean cascade = renameContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1");
        this.synchronizer.rename(renameContext, cascade);
        this.wrapped.rename(renameContext);
        this.updateSchemaModificationAttributes(renameContext);
    }

    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        return this.wrapped.search(searchContext);
    }

    public void unbind(UnbindOperationContext unbindContext) throws LdapException {
        this.wrapped.unbind(unbindContext);
    }

    public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
        return this.wrapped.lookup(lookupContext);
    }

    private void updateSchemaModificationAttributes(OperationContext opContext) throws LdapException {
        String modifiersName = opContext.getSession().getEffectivePrincipal().getName();
        String modifyTimestamp = DateUtils.getGeneralizedTime();
        ArrayList<Modification> mods = new ArrayList<Modification>(2);
        mods.add(new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, new DefaultAttribute("schemaModifyTimestamp", this.schemaManager.lookupAttributeTypeRegistry("schemaModifyTimestamp"), modifyTimestamp)));
        mods.add(new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, new DefaultAttribute("schemaModifiersName", this.schemaManager.lookupAttributeTypeRegistry("schemaModifiersName"), modifiersName)));
        opContext.modify(schemaModificationDn, mods, ByPassConstants.SCHEMA_MODIFICATION_ATTRIBUTES_UPDATE_BYPASS);
    }

    public String toString() {
        return "Partition : schema";
    }
}

