/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.schema.SchemaPartitionDao;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.cursor.Cursor;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultAttribute;
import org.apache.directory.shared.ldap.model.entry.DefaultModification;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.ModificationOperation;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.filter.AndNode;
import org.apache.directory.shared.ldap.model.filter.EqualityNode;
import org.apache.directory.shared.ldap.model.filter.OrNode;
import org.apache.directory.shared.ldap.model.filter.PresenceNode;
import org.apache.directory.shared.ldap.model.message.AliasDerefMode;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.AttributeTypeOptions;
import org.apache.directory.shared.ldap.model.schema.MatchingRule;
import org.apache.directory.shared.ldap.model.schema.ObjectClass;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.registries.Schema;
import org.apache.directory.shared.ldap.model.schema.syntaxCheckers.NumericOidSyntaxChecker;
import org.apache.directory.shared.ldap.schemaloader.SchemaEntityFactory;
import org.apache.directory.shared.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaPartitionDaoImpl
implements SchemaPartitionDao {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private static final NumericOidSyntaxChecker NUMERIC_OID_CHECKER = new NumericOidSyntaxChecker();
    private static final String[] SCHEMA_ATTRIBUTES = new String[]{"2.5.18.3", "m-dependencies", "2.5.4.0", "2.5.4.3", "m-disabled"};
    private final Partition partition;
    private final SchemaEntityFactory factory;
    private final SchemaManager schemaManager;
    private final AttributeType M_NAME_AT;
    private final AttributeType M_OID_AT;
    private final AttributeType OBJECT_CLASS_AT;
    private final AttributeType M_SYNTAX_AT;
    private final AttributeType M_ORDERING_AT;
    private final AttributeType M_SUBSTRING_AT;
    private final AttributeType M_EQUALITY_AT;
    private final AttributeType M_SUP_ATTRIBUTE_TYPE_AT;
    private final AttributeType M_MUST_AT;
    private final AttributeType M_MAY_AT;
    private final AttributeType M_AUX_AT;
    private final AttributeType M_OC_AT;
    private final AttributeType M_SUP_OBJECT_CLASS_AT;
    private final AttributeType M_DEPENDENCIES_AT;
    private final Set<AttributeTypeOptions> schemaAttributesToReturn = new HashSet<AttributeTypeOptions>();
    private final AttributeType disabledAttributeType;

    public SchemaPartitionDaoImpl(Partition partition, SchemaManager schemaManager) throws Exception {
        this.partition = partition;
        this.factory = new SchemaEntityFactory();
        this.schemaManager = schemaManager;
        this.M_NAME_AT = schemaManager.getAttributeType("m-name");
        this.disabledAttributeType = schemaManager.getAttributeType("m-disabled");
        this.M_OID_AT = schemaManager.getAttributeType("m-oid");
        this.OBJECT_CLASS_AT = schemaManager.getAttributeType("objectClass");
        this.M_SYNTAX_AT = schemaManager.getAttributeType("m-syntax");
        this.M_ORDERING_AT = schemaManager.getAttributeType("m-ordering");
        this.M_EQUALITY_AT = schemaManager.getAttributeType("m-equality");
        this.M_SUBSTRING_AT = schemaManager.getAttributeType("m-substr");
        this.M_SUP_ATTRIBUTE_TYPE_AT = schemaManager.getAttributeType("m-supAttributeType");
        this.M_MUST_AT = schemaManager.getAttributeType("m-must");
        this.M_MAY_AT = schemaManager.getAttributeType("m-may");
        this.M_AUX_AT = schemaManager.getAttributeType("m-aux");
        this.M_OC_AT = schemaManager.getAttributeType("m-oc");
        this.M_SUP_OBJECT_CLASS_AT = schemaManager.getAttributeType("m-supObjectClass");
        this.M_DEPENDENCIES_AT = schemaManager.getAttributeType("m-dependencies");
        for (String attrId : SCHEMA_ATTRIBUTES) {
            AttributeTypeOptions ato = new AttributeTypeOptions(schemaManager.lookupAttributeTypeRegistry(attrId));
            this.schemaAttributesToReturn.add(ato);
        }
    }

    @Override
    public Map<String, Schema> getSchemas() throws Exception {
        HashMap<String, Schema> schemas = new HashMap<String, Schema>();
        EntryFilteringCursor list = this.listSchemas();
        while (list.next()) {
            Entry sr = (Entry)list.get();
            Schema schema = this.factory.getSchema(sr);
            schemas.put(schema.getSchemaName(), schema);
        }
        return schemas;
    }

    @Override
    public Set<String> getSchemaNames() throws Exception {
        HashSet<String> schemaNames = new HashSet<String>();
        EntryFilteringCursor list = this.listSchemas();
        while (list.next()) {
            Entry sr = (Entry)list.get();
            schemaNames.add(sr.get("cn").getString());
        }
        return schemaNames;
    }

    private EntryFilteringCursor listSchemas() throws Exception {
        Dn base = new Dn(this.schemaManager, "ou=schema");
        EqualityNode<String> filter = new EqualityNode<String>(this.OBJECT_CLASS_AT, new StringValue("metaSchema"));
        SearchOperationContext searchContext = new SearchOperationContext(null);
        searchContext.setDn(base);
        searchContext.setScope(SearchScope.ONELEVEL);
        searchContext.setReturningAttributes(this.schemaAttributesToReturn);
        searchContext.setFilter(filter);
        return this.partition.search(searchContext);
    }

    @Override
    public Schema getSchema(String schemaName) throws Exception {
        Dn dn = new Dn(this.schemaManager, "cn=" + schemaName + ",ou=schema");
        return this.factory.getSchema(this.partition.lookup(new LookupOperationContext(null, dn)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMatchingRule(String oid) throws Exception {
        AndNode filter = new AndNode();
        filter.addNode(new EqualityNode<String>(this.OBJECT_CLASS_AT, new StringValue("metaMatchingRule")));
        if (NUMERIC_OID_CHECKER.isValidSyntax(oid)) {
            filter.addNode(new EqualityNode<String>(this.M_OID_AT, new StringValue(oid)));
        } else {
            filter.addNode(new EqualityNode<String>(this.M_NAME_AT, new StringValue(oid.toLowerCase())));
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        Cursor cursor = null;
        try {
            SearchOperationContext searchOperationContext = new SearchOperationContext(null, this.partition.getSuffix(), filter, searchControls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            cursor = this.partition.search(searchOperationContext);
            if (!cursor.next()) {
                boolean bl = false;
                return bl;
            }
            if (cursor.next()) {
                throw new NamingException(I18n.err(I18n.ERR_430, oid));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAttributeType(String oid) throws Exception {
        AndNode filter = new AndNode();
        filter.addNode(new EqualityNode<String>(this.OBJECT_CLASS_AT, new StringValue("metaAttributeType")));
        if (NUMERIC_OID_CHECKER.isValidSyntax(oid)) {
            filter.addNode(new EqualityNode<String>(this.M_OID_AT, new StringValue(oid)));
        } else {
            filter.addNode(new EqualityNode<String>(this.M_NAME_AT, new StringValue(oid.toLowerCase())));
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        Cursor cursor = null;
        try {
            SearchOperationContext searchOperationContext = new SearchOperationContext(null, this.partition.getSuffix(), filter, searchControls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            cursor = this.partition.search(searchOperationContext);
            if (!cursor.next()) {
                boolean bl = false;
                return bl;
            }
            if (cursor.next()) {
                throw new NamingException(I18n.err(I18n.ERR_431, oid));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasObjectClass(String oid) throws Exception {
        AndNode filter = new AndNode();
        filter.addNode(new EqualityNode<String>(this.OBJECT_CLASS_AT, new StringValue("metaObjectClass")));
        if (NUMERIC_OID_CHECKER.isValidSyntax(oid)) {
            filter.addNode(new EqualityNode<String>(this.M_OID_AT, new StringValue(oid)));
        } else {
            filter.addNode(new EqualityNode<String>(this.M_NAME_AT, new StringValue(oid.toLowerCase())));
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        Cursor cursor = null;
        try {
            SearchOperationContext searchOperationContext = new SearchOperationContext(null, this.partition.getSuffix(), filter, searchControls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            cursor = this.partition.search(searchOperationContext);
            if (!cursor.next()) {
                boolean bl = false;
                return bl;
            }
            if (cursor.next()) {
                throw new NamingException(I18n.err(I18n.ERR_431, oid));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasSyntax(String oid) throws Exception {
        AndNode filter = new AndNode();
        filter.addNode(new EqualityNode<String>(this.OBJECT_CLASS_AT, new StringValue("metaSyntax")));
        if (NUMERIC_OID_CHECKER.isValidSyntax(oid)) {
            filter.addNode(new EqualityNode<String>(this.M_OID_AT, new StringValue(oid)));
        } else {
            filter.addNode(new EqualityNode<String>(this.M_NAME_AT, new StringValue(oid.toLowerCase())));
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        Cursor cursor = null;
        try {
            SearchOperationContext searchOperationContext = new SearchOperationContext(null, this.partition.getSuffix(), filter, searchControls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            cursor = this.partition.search(searchOperationContext);
            if (!cursor.next()) {
                boolean bl = false;
                return bl;
            }
            if (cursor.next()) {
                throw new NamingException(I18n.err(I18n.ERR_432, oid));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasSyntaxChecker(String oid) throws Exception {
        AndNode filter = new AndNode();
        filter.addNode(new EqualityNode<String>(this.OBJECT_CLASS_AT, new StringValue("metaSyntaxChecker")));
        if (NUMERIC_OID_CHECKER.isValidSyntax(oid)) {
            filter.addNode(new EqualityNode<String>(this.M_OID_AT, new StringValue(oid)));
        } else {
            filter.addNode(new EqualityNode<String>(this.M_NAME_AT, new StringValue(oid.toLowerCase())));
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        Cursor cursor = null;
        try {
            SearchOperationContext searchOperationContext = new SearchOperationContext(null, this.partition.getSuffix(), filter, searchControls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            cursor = this.partition.search(searchOperationContext);
            if (!cursor.next()) {
                boolean bl = false;
                return bl;
            }
            if (cursor.next()) {
                throw new NamingException(I18n.err(I18n.ERR_433, oid));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    @Override
    public String findSchema(String entityName) throws Exception {
        Dn dn = this.findDn(entityName);
        if (dn == null) {
            return null;
        }
        Rdn rdn = dn.getRdn(dn.size() - 2);
        if (!rdn.getNormType().equalsIgnoreCase("2.5.4.3")) {
            throw new NamingException(I18n.err(I18n.ERR_434, dn.getNormName(), "2.5.4.3", rdn.getNormType()));
        }
        return rdn.getNormValue().getString();
    }

    @Override
    public Dn findDn(String entityName) throws Exception {
        Entry sr = this.find(entityName);
        Dn dn = new Dn(this.schemaManager, sr.getDn());
        return dn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entry find(String entityName) throws Exception {
        OrNode filter = new OrNode();
        EqualityNode<String> nameAVA = new EqualityNode<String>(this.M_NAME_AT, new StringValue(entityName.toLowerCase()));
        EqualityNode<String> oidAVA = new EqualityNode<String>(this.M_OID_AT, new StringValue(entityName.toLowerCase()));
        filter.addNode(nameAVA);
        filter.addNode(oidAVA);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        Cursor cursor = null;
        try {
            SearchOperationContext searchOperationContext = new SearchOperationContext(null, this.partition.getSuffix(), filter, searchControls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            cursor = this.partition.search(searchOperationContext);
            if (!cursor.next()) {
                Entry entry = null;
                return entry;
            }
            Entry sr = (Entry)cursor.get();
            if (cursor.next()) {
                throw new NamingException(I18n.err(I18n.ERR_435, entityName));
            }
            Entry entry = sr;
            return entry;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    @Override
    public void enableSchema(String schemaName) throws Exception {
        Dn dn = new Dn(this.schemaManager, "cn=" + schemaName + ",ou=schema");
        Entry entry = this.partition.lookup(new LookupOperationContext(null, dn));
        Attribute disabledAttr = entry.get(this.disabledAttributeType);
        ArrayList<Modification> mods = new ArrayList<Modification>(3);
        if (disabledAttr == null) {
            this.LOG.warn("Does not make sense: you're trying to enable {} schema which is already enabled", (Object)schemaName);
            return;
        }
        boolean isDisabled = disabledAttr.contains("TRUE");
        if (!isDisabled) {
            this.LOG.warn("Does not make sense: you're trying to enable {} schema which is already enabled", (Object)schemaName);
            return;
        }
        mods.add(new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, new DefaultAttribute("m-disabled", this.schemaManager.getAttributeType("m-disabled"))));
        mods.add(new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, new DefaultAttribute("modifiersName", this.schemaManager.getAttributeType("modifiersName"), "uid=admin,ou=system")));
        mods.add(new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, new DefaultAttribute("modifyTimestamp", this.schemaManager.getAttributeType("modifyTimestamp"), DateUtils.getGeneralizedTime())));
        this.partition.modify(new ModifyOperationContext(null, dn, mods));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Entry> listSyntaxDependents(String numericOid) throws Exception {
        HashSet<Entry> set = new HashSet<Entry>();
        AndNode filter = new AndNode();
        OrNode or = new OrNode();
        or.addNode(new EqualityNode<String>(this.OBJECT_CLASS_AT, new StringValue("metaMatchingRule".toLowerCase())));
        or.addNode(new EqualityNode<String>(this.OBJECT_CLASS_AT, new StringValue("metaAttributeType".toLowerCase())));
        filter.addNode(or);
        filter.addNode(new EqualityNode<String>(this.M_SYNTAX_AT, new StringValue(numericOid.toLowerCase())));
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        Cursor cursor = null;
        try {
            SearchOperationContext searchOperationContext = new SearchOperationContext(null, this.partition.getSuffix(), filter, searchControls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            cursor = this.partition.search(searchOperationContext);
            while (cursor.next()) {
                set.add((Entry)cursor.get());
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Entry> listMatchingRuleDependents(MatchingRule mr) throws Exception {
        HashSet<Entry> set = new HashSet<Entry>();
        AndNode filter = new AndNode();
        filter.addNode(new EqualityNode<String>(this.OBJECT_CLASS_AT, new StringValue("metaAttributeType".toLowerCase())));
        OrNode or = new OrNode();
        or.addNode(new EqualityNode<String>(this.M_ORDERING_AT, new StringValue(mr.getOid())));
        or.addNode(new EqualityNode<String>(this.M_SUBSTRING_AT, new StringValue(mr.getOid())));
        or.addNode(new EqualityNode<String>(this.M_EQUALITY_AT, new StringValue(mr.getOid())));
        filter.addNode(or);
        List<String> names = mr.getNames();
        if (names != null && names.size() > 0) {
            for (String name : names) {
                or.addNode(new EqualityNode<String>(this.M_ORDERING_AT, new StringValue(name.toLowerCase())));
                or.addNode(new EqualityNode<String>(this.M_SUBSTRING_AT, new StringValue(name.toLowerCase())));
                or.addNode(new EqualityNode<String>(this.M_EQUALITY_AT, new StringValue(name.toLowerCase())));
            }
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        Cursor cursor = null;
        try {
            SearchOperationContext searchOperationContext = new SearchOperationContext(null, this.partition.getSuffix(), filter, searchControls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            cursor = this.partition.search(searchOperationContext);
            while (cursor.next()) {
                set.add((Entry)cursor.get());
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return set;
    }

    @Override
    public EntryFilteringCursor listAllNames() throws Exception {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        AndNode filter = new AndNode();
        filter.addNode(new PresenceNode(this.M_OID_AT));
        filter.addNode(new PresenceNode(this.M_NAME_AT));
        SearchOperationContext searchOperationContext = new SearchOperationContext(null, this.partition.getSuffix(), filter, searchControls);
        searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
        return this.partition.search(searchOperationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Entry> listAttributeTypeDependents(AttributeType at) throws Exception {
        HashSet<Entry> set = new HashSet<Entry>();
        AndNode filter = new AndNode();
        OrNode or = new OrNode();
        or.addNode(new EqualityNode<String>(this.OBJECT_CLASS_AT, new StringValue("metaAttributeType".toLowerCase())));
        or.addNode(new EqualityNode<String>(this.OBJECT_CLASS_AT, new StringValue("metaObjectClass".toLowerCase())));
        filter.addNode(or);
        or = new OrNode();
        or.addNode(new EqualityNode<String>(this.M_MAY_AT, new StringValue(at.getOid())));
        or.addNode(new EqualityNode<String>(this.M_MUST_AT, new StringValue(at.getOid())));
        or.addNode(new EqualityNode<String>(this.M_SUP_ATTRIBUTE_TYPE_AT, new StringValue(at.getOid())));
        filter.addNode(or);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        Cursor cursor = null;
        try {
            SearchOperationContext searchOperationContext = new SearchOperationContext(null, this.partition.getSuffix(), filter, searchControls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            cursor = this.partition.search(searchOperationContext);
            while (cursor.next()) {
                set.add((Entry)cursor.get());
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Entry> listSchemaDependents(String schemaName) throws Exception {
        HashSet<Entry> set = new HashSet<Entry>();
        AndNode filter = new AndNode();
        filter.addNode(new EqualityNode<String>(this.OBJECT_CLASS_AT, new StringValue("metaSchema".toLowerCase())));
        filter.addNode(new EqualityNode<String>(this.M_DEPENDENCIES_AT, new StringValue(schemaName.toLowerCase())));
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(1);
        Cursor cursor = null;
        try {
            SearchOperationContext searchOperationContext = new SearchOperationContext(null, this.partition.getSuffix(), filter, searchControls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            cursor = this.partition.search(searchOperationContext);
            while (cursor.next()) {
                set.add((Entry)cursor.get());
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Entry> listEnabledSchemaDependents(String schemaName) throws Exception {
        HashSet<Entry> set = new HashSet<Entry>();
        AndNode filter = new AndNode();
        filter.addNode(new EqualityNode<String>(this.OBJECT_CLASS_AT, new StringValue("metaSchema".toLowerCase())));
        filter.addNode(new EqualityNode<String>(this.M_DEPENDENCIES_AT, new StringValue(schemaName.toLowerCase())));
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(1);
        Cursor cursor = null;
        try {
            SearchOperationContext searchOperationContext = new SearchOperationContext(null, this.partition.getSuffix(), filter, searchControls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            cursor = this.partition.search(searchOperationContext);
            while (cursor.next()) {
                Entry sr = (Entry)cursor.get();
                Attribute disabled = sr.get(this.disabledAttributeType);
                if (disabled == null) {
                    set.add(sr);
                    continue;
                }
                if (!disabled.get().toString().equals("FALSE")) continue;
                set.add(sr);
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Entry> listObjectClassDependents(ObjectClass oc) throws Exception {
        HashSet<Entry> set = new HashSet<Entry>();
        AndNode filter = new AndNode();
        OrNode or = new OrNode();
        or.addNode(new EqualityNode<String>(this.OBJECT_CLASS_AT, new StringValue("metaNameForm".toLowerCase())));
        or.addNode(new EqualityNode<String>(this.OBJECT_CLASS_AT, new StringValue("metaObjectClass".toLowerCase())));
        or.addNode(new EqualityNode<String>(this.OBJECT_CLASS_AT, new StringValue("metaDITContentRule".toLowerCase())));
        filter.addNode(or);
        or = new OrNode();
        or.addNode(new EqualityNode<String>(this.M_AUX_AT, new StringValue(oc.getOid())));
        or.addNode(new EqualityNode<String>(this.M_OC_AT, new StringValue(oc.getOid())));
        or.addNode(new EqualityNode<String>(this.M_SUP_OBJECT_CLASS_AT, new StringValue(oc.getOid())));
        filter.addNode(or);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        Cursor cursor = null;
        try {
            SearchOperationContext searchOperationContext = new SearchOperationContext(null, this.partition.getSuffix(), filter, searchControls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            cursor = this.partition.search(searchOperationContext);
            while (cursor.next()) {
                set.add((Entry)cursor.get());
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return set;
    }
}

