/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.directory.server.core.DnFactory;
import org.apache.directory.server.core.authn.AuthenticationInterceptor;
import org.apache.directory.server.core.authz.AciAuthorizationInterceptor;
import org.apache.directory.server.core.authz.DefaultAuthorizationInterceptor;
import org.apache.directory.server.core.exception.ExceptionInterceptor;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.schema.AttributesFactory;
import org.apache.directory.server.core.schema.SchemaInterceptor;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.DITContentRule;
import org.apache.directory.shared.ldap.model.schema.DITStructureRule;
import org.apache.directory.shared.ldap.model.schema.LdapSyntax;
import org.apache.directory.shared.ldap.model.schema.MatchingRule;
import org.apache.directory.shared.ldap.model.schema.MatchingRuleUse;
import org.apache.directory.shared.ldap.model.schema.NameForm;
import org.apache.directory.shared.ldap.model.schema.ObjectClass;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.SchemaObject;
import org.apache.directory.shared.ldap.model.schema.parsers.LdapComparatorDescription;
import org.apache.directory.shared.ldap.model.schema.parsers.NormalizerDescription;
import org.apache.directory.shared.ldap.model.schema.parsers.SyntaxCheckerDescription;
import org.apache.directory.shared.ldap.model.schema.registries.Schema;
import org.apache.directory.shared.util.Base64;

public class SchemaSubentryModifier {
    private static final Collection<String> BYPASS;
    private AttributesFactory factory = new AttributesFactory();
    private SchemaManager schemaManager;
    private DnFactory dnFactory;

    public SchemaSubentryModifier(SchemaManager schemaManager, DnFactory dnFactory) {
        this.schemaManager = schemaManager;
        this.dnFactory = dnFactory;
    }

    private Dn getDn(SchemaObject obj) throws LdapInvalidDnException {
        StringBuffer buf = new StringBuffer();
        buf.append("m-oid=").append(obj.getOid()).append(",ou=");
        if (obj instanceof LdapSyntax) {
            buf.append("syntaxes");
        } else if (obj instanceof MatchingRule) {
            buf.append("matchingRules");
        } else if (obj instanceof AttributeType) {
            buf.append("attributeTypes");
        } else if (obj instanceof ObjectClass) {
            buf.append("objectClasses");
        } else if (obj instanceof MatchingRuleUse) {
            buf.append("matchingRuleUse");
        } else if (obj instanceof DITStructureRule) {
            buf.append("ditStructureRules");
        } else if (obj instanceof DITContentRule) {
            buf.append("ditContentRules");
        } else if (obj instanceof NameForm) {
            buf.append("nameForms");
        }
        buf.append(",cn=").append(obj.getSchemaName()).append(",ou=schema");
        return this.dnFactory.create(buf.toString());
    }

    public void add(OperationContext opContext, LdapComparatorDescription comparatorDescription) throws LdapException {
        String schemaName = this.getSchema(comparatorDescription);
        Dn dn = this.dnFactory.create("m-oid=" + comparatorDescription.getOid(), "ou=comparators", "cn=" + schemaName, "ou=schema");
        Entry entry = this.getEntry(dn, comparatorDescription);
        opContext.add(entry, BYPASS);
    }

    public void add(OperationContext opContext, NormalizerDescription normalizerDescription) throws LdapException {
        String schemaName = this.getSchema(normalizerDescription);
        Dn dn = this.dnFactory.create("m-oid=" + normalizerDescription.getOid(), "ou=normalizers", "cn=" + schemaName, "ou=schema");
        Entry entry = this.getEntry(dn, normalizerDescription);
        opContext.add(entry, BYPASS);
    }

    public void add(OperationContext opContext, SyntaxCheckerDescription syntaxCheckerDescription) throws LdapException {
        String schemaName = this.getSchema(syntaxCheckerDescription);
        Dn dn = this.dnFactory.create("m-oid=" + syntaxCheckerDescription.getOid(), "ou=syntaxcheckers", "cn=" + schemaName, "ou=schema");
        Entry entry = this.getEntry(dn, syntaxCheckerDescription);
        opContext.add(entry, BYPASS);
    }

    public void addSchemaObject(OperationContext opContext, SchemaObject obj) throws LdapException {
        Schema schema = this.schemaManager.getLoadedSchema(obj.getSchemaName());
        Dn dn = this.getDn(obj);
        Entry entry = this.factory.getAttributes(obj, schema, this.schemaManager);
        entry.setDn(dn);
        opContext.add(entry, BYPASS);
    }

    public void deleteSchemaObject(OperationContext opContext, SchemaObject obj) throws LdapException {
        Dn dn = this.getDn(obj);
        opContext.delete(dn, BYPASS);
    }

    public void delete(OperationContext opContext, NormalizerDescription normalizerDescription) throws LdapException {
        String schemaName = this.getSchema(normalizerDescription);
        Dn dn = this.dnFactory.create("m-oid=" + normalizerDescription.getOid(), "ou=normalizers", "cn=" + schemaName, "ou=schema");
        opContext.delete(dn, BYPASS);
    }

    public void delete(OperationContext opContext, SyntaxCheckerDescription syntaxCheckerDescription) throws LdapException {
        String schemaName = this.getSchema(syntaxCheckerDescription);
        Dn dn = this.dnFactory.create("m-oid=" + syntaxCheckerDescription.getOid(), "ou=syntaxcheckers", "cn=" + schemaName, "ou=schema");
        opContext.delete(dn, BYPASS);
    }

    public void delete(OperationContext opContext, LdapComparatorDescription comparatorDescription) throws LdapException {
        String schemaName = this.getSchema(comparatorDescription);
        Dn dn = this.dnFactory.create("m-oid=" + comparatorDescription.getOid(), "ou=comparators", "cn=" + schemaName, "ou=schema");
        opContext.delete(dn, BYPASS);
    }

    private Entry getEntry(Dn dn, LdapComparatorDescription comparatorDescription) {
        DefaultEntry entry = new DefaultEntry(this.schemaManager, dn);
        entry.put("objectClass", "top", "metaTop", "metaComparator");
        entry.put("m-oid", comparatorDescription.getOid());
        entry.put("m-fqcn", comparatorDescription.getFqcn());
        if (comparatorDescription.getBytecode() != null) {
            entry.put("m-bytecode", (byte[][])new byte[][]{Base64.decode(comparatorDescription.getBytecode().toCharArray())});
        }
        if (comparatorDescription.getDescription() != null) {
            entry.put("m-description", comparatorDescription.getDescription());
        }
        return entry;
    }

    private Entry getEntry(Dn dn, NormalizerDescription normalizerDescription) {
        DefaultEntry entry = new DefaultEntry(this.schemaManager, dn);
        entry.put("objectClass", "top", "metaTop", "metaNormalizer");
        entry.put("m-oid", normalizerDescription.getOid());
        entry.put("m-fqcn", normalizerDescription.getFqcn());
        if (normalizerDescription.getBytecode() != null) {
            entry.put("m-bytecode", (byte[][])new byte[][]{Base64.decode(normalizerDescription.getBytecode().toCharArray())});
        }
        if (normalizerDescription.getDescription() != null) {
            entry.put("m-description", normalizerDescription.getDescription());
        }
        return entry;
    }

    private String getSchema(SchemaObject desc) {
        if (desc.getExtensions().containsKey("X-SCHEMA")) {
            return desc.getExtensions().get("X-SCHEMA").get(0);
        }
        return "other";
    }

    private Entry getEntry(Dn dn, SyntaxCheckerDescription syntaxCheckerDescription) {
        DefaultEntry entry = new DefaultEntry(this.schemaManager, dn);
        entry.put("objectClass", "top", "metaTop", "metaSyntaxChecker");
        entry.put("m-oid", syntaxCheckerDescription.getOid());
        entry.put("m-fqcn", syntaxCheckerDescription.getFqcn());
        if (syntaxCheckerDescription.getBytecode() != null) {
            entry.put("m-bytecode", (byte[][])new byte[][]{Base64.decode(syntaxCheckerDescription.getBytecode().toCharArray())});
        }
        if (syntaxCheckerDescription.getDescription() != null) {
            entry.put("m-description", syntaxCheckerDescription.getDescription());
        }
        return entry;
    }

    static {
        HashSet<String> c = new HashSet<String>();
        c.add(AuthenticationInterceptor.class.getName());
        c.add(AciAuthorizationInterceptor.class.getName());
        c.add(DefaultAuthorizationInterceptor.class.getName());
        c.add(ExceptionInterceptor.class.getName());
        c.add(SchemaInterceptor.class.getName());
        BYPASS = Collections.unmodifiableCollection(c);
    }
}

