/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.extended;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.SerializationUtils;
import org.apache.directory.server.core.sp.StoredProcEngine;
import org.apache.directory.server.core.sp.StoredProcEngineConfig;
import org.apache.directory.server.core.sp.StoredProcExecutionManager;
import org.apache.directory.server.core.sp.java.JavaStoredProcEngineConfig;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.shared.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.shared.ldap.extras.extended.StoredProcedureRequest;
import org.apache.directory.shared.ldap.extras.extended.StoredProcedureResponse;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.sp.LdapContextParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredProcedureExtendedOperationHandler
implements ExtendedOperationHandler<StoredProcedureRequest, StoredProcedureResponse> {
    private StoredProcExecutionManager manager;
    private static final Object[] EMPTY_CLASS_ARRAY = new Object[0];
    private static final Set<String> EXTENSION_OIDS;

    public StoredProcedureExtendedOperationHandler() {
        JavaStoredProcEngineConfig javaSPEngineConfig = new JavaStoredProcEngineConfig();
        ArrayList<StoredProcEngineConfig> spEngineConfigs = new ArrayList<StoredProcEngineConfig>();
        spEngineConfigs.add(javaSPEngineConfig);
        String spContainer = "ou=Stored Procedures,ou=system";
        this.manager = new StoredProcExecutionManager(spContainer, spEngineConfigs);
    }

    @Override
    public void handleExtendedOperation(LdapSession session, StoredProcedureRequest req) throws Exception {
        String procedure = req.getProcedureSpecification();
        Entry spUnit = this.manager.findStoredProcUnit(session.getCoreSession(), procedure);
        StoredProcEngine engine = this.manager.getStoredProcEngineInstance(spUnit);
        ArrayList<Object> valueList = new ArrayList<Object>(req.size());
        for (int ii = 0; ii < req.size(); ++ii) {
            byte[] serializedValue = (byte[])req.getParameterValue(ii);
            Object value = SerializationUtils.deserialize(serializedValue);
            if (value.getClass().equals(LdapContextParameter.class)) {
                String paramCtx = ((LdapContextParameter)value).getValue();
                value = session.getCoreSession().lookup(new Dn(paramCtx));
            }
            valueList.add(value);
        }
        Object[] values = valueList.toArray(EMPTY_CLASS_ARRAY);
        Object response = engine.invokeProcedure(session.getCoreSession(), procedure, values);
        byte[] serializedResponse = SerializationUtils.serialize((Serializable)response);
        StoredProcedureResponse resp = LdapApiServiceFactory.getSingleton().newExtendedResponse(req, serializedResponse);
        session.getIoSession().write(resp);
    }

    @Override
    public String getOid() {
        return "1.3.6.1.4.1.18060.0.1.6";
    }

    @Override
    public Set<String> getExtensionOids() {
        return EXTENSION_OIDS;
    }

    @Override
    public void setLdapServer(LdapServer ldapServer) {
    }

    static {
        HashSet<String> s = new HashSet<String>();
        s.add("1.3.6.1.4.1.18060.0.1.6");
        s.add("1.3.6.1.4.1.18060.0.1.6");
        EXTENSION_OIDS = Collections.unmodifiableSet(s);
    }
}

