/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication;

import java.util.Iterator;
import org.apache.activemq.ActiveMQQueueBrowser;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.command.ActiveMQObjectMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.directory.server.ldap.replication.ReplicaEventMessage;
import org.apache.directory.shared.ldap.model.cursor.AbstractCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReplicaEventLogCursor
extends AbstractCursor<ReplicaEventMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicaEventLogCursor.class);
    private ActiveMQQueueBrowser browser;
    private Queue regionQueue;

    public ReplicaEventLogCursor(ActiveMQSession session, ActiveMQQueue queue, Queue regionQueue) throws Exception {
        this.browser = (ActiveMQQueueBrowser)session.createBrowser(queue);
        this.regionQueue = regionQueue;
    }

    @Override
    public void after(ReplicaEventMessage arg0) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void afterLast() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean available() {
        return this.browser.hasMoreElements();
    }

    @Override
    public void before(ReplicaEventMessage arg0) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void beforeFirst() throws Exception {
    }

    @Override
    public boolean first() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public ReplicaEventMessage get() throws Exception {
        ActiveMQObjectMessage amqObj = (ActiveMQObjectMessage)this.browser.nextElement();
        LOG.debug("ReplicaEventMessage: {}", amqObj);
        ReplicaEventMessage message = (ReplicaEventMessage)amqObj.getObject();
        this.regionQueue.removeMessage(amqObj.getJMSMessageID());
        return message;
    }

    @Override
    public boolean last() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean next() throws Exception {
        return this.browser.hasMoreElements();
    }

    @Override
    public boolean previous() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws Exception {
        this.browser.close();
        super.close();
    }

    @Override
    public void close(Exception cause) throws Exception {
        this.browser.close();
        super.close(cause);
    }

    @Override
    public Iterator<ReplicaEventMessage> iterator() {
        throw new UnsupportedOperationException();
    }
}

