/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.directory.ldap.client.api.ConnectionClosedEventListener;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.ldap.client.api.future.SearchFuture;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.ldap.replication.ReplicationConsumer;
import org.apache.directory.server.ldap.replication.ReplicationConsumerConfig;
import org.apache.directory.server.ldap.replication.SyncreplConfiguration;
import org.apache.directory.shared.ldap.codec.controls.manageDsaIT.ManageDsaITDecorator;
import org.apache.directory.shared.ldap.extras.controls.SyncDoneValue;
import org.apache.directory.shared.ldap.extras.controls.SyncInfoValue;
import org.apache.directory.shared.ldap.extras.controls.SyncModifyDn;
import org.apache.directory.shared.ldap.extras.controls.SyncModifyDnType;
import org.apache.directory.shared.ldap.extras.controls.SyncStateTypeEnum;
import org.apache.directory.shared.ldap.extras.controls.SyncStateValue;
import org.apache.directory.shared.ldap.extras.controls.SynchronizationModeEnum;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncInfoValueDecorator;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncRequestValueDecorator;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultAttribute;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.DefaultModification;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.ModificationOperation;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.filter.AbstractExprNode;
import org.apache.directory.shared.ldap.model.filter.AndNode;
import org.apache.directory.shared.ldap.model.filter.EqualityNode;
import org.apache.directory.shared.ldap.model.filter.NotNode;
import org.apache.directory.shared.ldap.model.filter.OrNode;
import org.apache.directory.shared.ldap.model.filter.PresenceNode;
import org.apache.directory.shared.ldap.model.message.AliasDerefMode;
import org.apache.directory.shared.ldap.model.message.IntermediateResponse;
import org.apache.directory.shared.ldap.model.message.Response;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.message.SearchRequest;
import org.apache.directory.shared.ldap.model.message.SearchRequestImpl;
import org.apache.directory.shared.ldap.model.message.SearchResultDone;
import org.apache.directory.shared.ldap.model.message.SearchResultEntry;
import org.apache.directory.shared.ldap.model.message.SearchResultReference;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.apache.directory.shared.ldap.model.message.controls.ManageDsaITImpl;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.AttributeTypeOptions;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncReplConsumer
implements ConnectionClosedEventListener,
ReplicationConsumer {
    private SyncreplConfiguration config;
    private byte[] syncCookie;
    private static final Logger LOG = LoggerFactory.getLogger(SyncReplConsumer.class);
    private LdapNetworkConnection connection;
    private SearchRequest searchRequest;
    private DirectoryService directoryService;
    private SchemaManager schemaManager;
    private File cookieFile;
    private boolean disconnected;
    private CoreSession session;
    private static final String[] MOD_IGNORE_AT = new String[]{"entryUUID", "entryCSN", "modifiersName", "modifyTimestamp", "createTimestamp", "creatorsName", "entryParentId"};
    private RefresherThread refreshThread;
    private byte[] lastSavedCookie;
    private static AttributeType ENTRY_UUID_AT;
    private static final PresenceNode ENTRY_UUID_PRESENCE_FILTER;
    private static final Set<AttributeTypeOptions> ENTRY_UUID_ATOP_SET;
    private List<Modification> cookieModLst;
    private static AttributeType COOKIE_AT_TYPE;

    @Override
    public SyncreplConfiguration getConfig() {
        return this.config;
    }

    @Override
    public void init(DirectoryService directoryservice) throws Exception {
        this.directoryService = directoryservice;
        if (this.config.isStoreCookieInFile()) {
            File cookieDir = new File(directoryservice.getInstanceLayout().getRunDirectory(), "cookies");
            cookieDir.mkdir();
            this.cookieFile = new File(cookieDir, String.valueOf(this.config.getReplicaId()));
        }
        this.session = this.directoryService.getAdminSession();
        this.schemaManager = directoryservice.getSchemaManager();
        ENTRY_UUID_AT = this.schemaManager.lookupAttributeTypeRegistry("entryUUID");
        ENTRY_UUID_ATOP_SET.add(new AttributeTypeOptions(ENTRY_UUID_AT));
        COOKIE_AT_TYPE = this.schemaManager.lookupAttributeTypeRegistry("ads-replCookie");
        DefaultAttribute cookieAttr = new DefaultAttribute(COOKIE_AT_TYPE);
        DefaultModification cookieMod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, cookieAttr);
        this.cookieModLst = new ArrayList<Modification>(1);
        this.cookieModLst.add(cookieMod);
        this.prepareSyncSearchRequest();
    }

    public boolean connect() {
        try {
            String providerHost = this.config.getProviderHost();
            int port = this.config.getPort();
            if (this.connection == null) {
                this.connection = new LdapNetworkConnection(providerHost, port);
                if (this.config.isUseTls()) {
                    this.connection.getConfig().setTrustManagers(this.config.getTrustManager());
                    this.connection.startTls();
                }
                this.connection.addConnectionClosedEventListener(this);
            }
            try {
                this.connection.bind(this.config.getReplUserDn(), Strings.utf8ToString(this.config.getReplUserPassword()));
                return true;
            }
            catch (LdapException le) {
                LOG.warn("Failed to bind to the server with the given bind Dn {}", (Object)this.config.getReplUserDn());
                LOG.warn("", le);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to bind with the given bindDN and credentials", e);
        }
        return false;
    }

    public void prepareSyncSearchRequest() throws LdapException {
        String baseDn = this.config.getBaseDn();
        this.searchRequest = new SearchRequestImpl();
        this.searchRequest.setBase(new Dn(baseDn));
        this.searchRequest.setFilter(this.config.getFilter());
        this.searchRequest.setSizeLimit(this.config.getSearchSizeLimit());
        this.searchRequest.setTimeLimit(this.config.getSearchTimeout());
        this.searchRequest.setDerefAliases(this.config.getAliasDerefMode());
        this.searchRequest.setScope(this.config.getSearchScope());
        this.searchRequest.setTypesOnly(false);
        this.searchRequest.addAttributes(this.config.getAttributes());
        if (!this.config.isChaseReferrals()) {
            this.searchRequest.addControl(new ManageDsaITDecorator(this.directoryService.getLdapCodecService(), new ManageDsaITImpl()));
        }
    }

    public ResultCodeEnum handleSearchDone(SearchResultDone searchDone) {
        LOG.debug("///////////////// handleSearchDone //////////////////");
        SyncDoneValue ctrl = (SyncDoneValue)searchDone.getControls().get("1.3.6.1.4.1.4203.1.9.1.3");
        if (ctrl != null && ctrl.getCookie() != null) {
            this.syncCookie = ctrl.getCookie();
            LOG.debug("assigning cookie from sync done value control: " + Strings.utf8ToString(this.syncCookie));
            this.storeCookie();
        }
        LOG.debug("//////////////// END handleSearchDone//////////////////////");
        return searchDone.getLdapResult().getResultCode();
    }

    public void handleSearchReference(SearchResultReference searchRef) {
    }

    public void handleSearchResult(SearchResultEntry syncResult) {
        LOG.debug("------------- starting handleSearchResult ------------");
        SyncStateValue syncStateCtrl = (SyncStateValue)syncResult.getControl("1.3.6.1.4.1.4203.1.9.1.2");
        try {
            Entry remoteEntry = syncResult.getEntry();
            if (syncStateCtrl.getCookie() != null) {
                this.syncCookie = syncStateCtrl.getCookie();
                LOG.debug("assigning the cookie from sync state value control: " + Strings.utf8ToString(this.syncCookie));
            }
            SyncStateTypeEnum state = syncStateCtrl.getSyncStateType();
            LOG.debug("state name {}", (Object)state.name());
            if (LOG.isDebugEnabled()) {
                LOG.debug("entryUUID = {}", (Object)Strings.uuidToString(syncStateCtrl.getEntryUUID()));
            }
            switch (state) {
                case ADD: {
                    if (!this.session.exists(remoteEntry.getDn())) {
                        LOG.debug("adding entry with dn {}", (Object)remoteEntry.getDn().getName());
                        LOG.debug(remoteEntry.toString());
                        this.session.add(new DefaultEntry(this.schemaManager, remoteEntry));
                        break;
                    }
                    LOG.debug("updating entry in refreshOnly mode {}", (Object)remoteEntry.getDn().getName());
                    this.modify(remoteEntry);
                    break;
                }
                case MODIFY: {
                    LOG.debug("modifying entry with dn {}", (Object)remoteEntry.getDn().getName());
                    this.modify(remoteEntry);
                    break;
                }
                case MODDN: {
                    SyncModifyDn adsModDnControl = (SyncModifyDn)syncResult.getControls().get("1.3.6.1.4.1.4203.1.9.1.5");
                    this.applyModDnOperation(adsModDnControl);
                    break;
                }
                case DELETE: {
                    LOG.debug("deleting entry with dn {}", (Object)remoteEntry.getDn().getName());
                    this.deleteRecursive(remoteEntry.getDn(), null);
                    break;
                }
                case PRESENT: {
                    LOG.debug("entry present {}", remoteEntry);
                }
            }
            if (syncStateCtrl.getCookie() != null) {
                this.storeCookie();
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
        LOG.debug("------------- Ending handleSearchResult ------------");
    }

    public void handleSyncInfo(IntermediateResponse syncInfoResp) {
        try {
            LOG.debug("............... inside handleSyncInfo ...............");
            SyncInfoValueDecorator decorator = new SyncInfoValueDecorator(this.directoryService.getLdapCodecService());
            byte[] syncinfo = syncInfoResp.getResponseValue();
            decorator.setValue(syncinfo);
            SyncInfoValue syncInfoValue = (SyncInfoValue)decorator.getDecorated();
            byte[] cookie = syncInfoValue.getCookie();
            if (cookie != null) {
                LOG.debug("setting the cookie from the sync info: " + Strings.utf8ToString(cookie));
                this.syncCookie = cookie;
            }
            LOG.info("refreshDeletes: " + syncInfoValue.isRefreshDeletes());
            List<byte[]> uuidList = syncInfoValue.getSyncUUIDs();
            if (syncInfoValue.isRefreshDeletes()) {
                this.deleteEntries(uuidList, false);
            } else {
                this.deleteEntries(uuidList, true);
            }
            LOG.info("refreshDone: " + syncInfoValue.isRefreshDone());
            this.storeCookie();
        }
        catch (Exception de) {
            LOG.error("Failed to handle syncinfo message");
            de.printStackTrace();
        }
        LOG.debug(".................... END handleSyncInfo ...............");
    }

    @Override
    public void connectionClosed() {
        if (this.disconnected) {
            return;
        }
        boolean connected = false;
        while (!connected) {
            try {
                Thread.sleep(this.config.getRefreshInterval());
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted while sleeping before trying to reconnect", e);
            }
            LOG.debug("Trying to reconnect");
            connected = this.connect();
        }
        this.startSync();
    }

    public void startSync() {
        this.readCookie();
        if (this.config.isRefreshNPersist()) {
            try {
                LOG.debug("==================== Refresh And Persist ==========");
                this.doSyncSearch(SynchronizationModeEnum.REFRESH_AND_PERSIST, false);
            }
            catch (Exception e) {
                LOG.error("Failed to sync with refreshAndPersist mode", e);
            }
        } else {
            this.refreshThread = new RefresherThread();
            this.refreshThread.start();
        }
    }

    @Override
    public void setConfig(ReplicationConsumerConfig config) {
        this.config = (SyncreplConfiguration)config;
    }

    @Override
    public void start() {
        this.connect();
        this.startSync();
    }

    @Override
    public void stop() {
        this.disconnet();
    }

    @Override
    public String getId() {
        return String.valueOf(this.getConfig().getReplicaId());
    }

    private void doSyncSearch(SynchronizationModeEnum syncType, boolean reloadHint) throws Exception {
        SyncRequestValueDecorator syncReq = new SyncRequestValueDecorator(this.directoryService.getLdapCodecService());
        syncReq.setMode(syncType);
        syncReq.setReloadHint(reloadHint);
        if (this.syncCookie != null) {
            LOG.debug("searching with searchRequest, cookie '{}'", (Object)Strings.utf8ToString(this.syncCookie));
            syncReq.setCookie(this.syncCookie);
        }
        this.searchRequest.addControl(syncReq);
        SearchFuture sf = this.connection.searchAsync(this.searchRequest);
        Response resp = sf.get();
        while (!(resp instanceof SearchResultDone) && !sf.isCancelled()) {
            if (resp instanceof SearchResultEntry) {
                this.handleSearchResult((SearchResultEntry)resp);
            } else if (resp instanceof SearchResultReference) {
                this.handleSearchReference((SearchResultReference)resp);
            } else if (resp instanceof IntermediateResponse) {
                this.handleSyncInfo((IntermediateResponse)resp);
            }
            resp = sf.get();
        }
        ResultCodeEnum resultCode = this.handleSearchDone((SearchResultDone)resp);
        LOG.debug("sync operation returned result code {}", (Object)resultCode);
        if (resultCode == ResultCodeEnum.NO_SUCH_OBJECT) {
            LOG.warn("given replication base Dn {} is not found on provider", (Object)this.config.getBaseDn());
            if (syncType == SynchronizationModeEnum.REFRESH_AND_PERSIST) {
                LOG.warn("disconnecting the consumer running in refreshAndPersist mode from the provider");
                this.disconnet();
            }
        } else if (resultCode == ResultCodeEnum.E_SYNC_REFRESH_REQUIRED) {
            LOG.info("unable to perform the content synchronization cause E_SYNC_REFRESH_REQUIRED");
            try {
                this.deleteRecursive(new Dn(this.config.getBaseDn()), null);
            }
            catch (Exception e) {
                LOG.error("Failed to delete the replica base as part of handling E_SYNC_REFRESH_REQUIRED, disconnecting the consumer", e);
                this.disconnet();
            }
            this.removeCookie();
            this.doSyncSearch(syncType, true);
        }
    }

    public void disconnet() {
        this.disconnected = true;
        try {
            if (this.refreshThread != null) {
                this.refreshThread.stopRefreshing();
            }
            this.connection.unBind();
            LOG.info("Unbound from the server {}", (Object)this.config.getProviderHost());
            this.connection.close();
            LOG.info("Connection closed for the server {}", (Object)this.config.getProviderHost());
            this.connection = null;
            this.storeCookie();
            this.syncCookie = null;
        }
        catch (Exception e) {
            LOG.error("Failed to close the connection", e);
        }
    }

    private void storeCookie() {
        if (this.syncCookie == null) {
            return;
        }
        if (this.lastSavedCookie != null && Arrays.equals(this.syncCookie, this.lastSavedCookie)) {
            return;
        }
        try {
            if (this.config.isStoreCookieInFile()) {
                FileOutputStream fout = new FileOutputStream(this.cookieFile);
                fout.write(this.syncCookie.length);
                fout.write(this.syncCookie);
                fout.close();
            } else {
                Attribute attr = this.cookieModLst.get(0).getAttribute();
                attr.clear();
                attr.add(new byte[][]{this.syncCookie});
                this.session.modify(this.config.getConfigEntryDn(), this.cookieModLst);
            }
            this.lastSavedCookie = new byte[this.syncCookie.length];
            System.arraycopy(this.syncCookie, 0, this.lastSavedCookie, 0, this.syncCookie.length);
            LOG.debug("stored the cookie");
        }
        catch (Exception e) {
            LOG.error("Failed to store the cookie", e);
        }
    }

    private void readCookie() {
        block7: {
            try {
                if (this.config.isStoreCookieInFile()) {
                    if (this.cookieFile.exists() && this.cookieFile.length() > 0L) {
                        FileInputStream fin = new FileInputStream(this.cookieFile);
                        this.syncCookie = new byte[fin.read()];
                        fin.read(this.syncCookie);
                        fin.close();
                        this.lastSavedCookie = new byte[this.syncCookie.length];
                        System.arraycopy(this.syncCookie, 0, this.lastSavedCookie, 0, this.syncCookie.length);
                        LOG.debug("read the cookie from file: " + Strings.utf8ToString(this.syncCookie));
                    }
                    break block7;
                }
                try {
                    Attribute attr;
                    Entry entry = this.session.lookup(this.config.getConfigEntryDn(), COOKIE_AT_TYPE.getName());
                    if (entry != null && (attr = entry.get(COOKIE_AT_TYPE)) != null) {
                        this.syncCookie = attr.getBytes();
                        this.lastSavedCookie = this.syncCookie;
                        LOG.debug("loaded cookie from DIT");
                    }
                }
                catch (Exception e) {
                    LOG.debug("Failed to read the cookie from the entry", e);
                }
            }
            catch (Exception e) {
                LOG.error("Failed to read the cookie", e);
            }
        }
    }

    public void removeCookie() {
        if (this.config.isStoreCookieInFile()) {
            if (this.cookieFile.exists() && this.cookieFile.length() > 0L) {
                boolean deleted = this.cookieFile.delete();
                LOG.info("deleted cookie file {}", deleted);
            }
        } else {
            try {
                DefaultAttribute cookieAttr = new DefaultAttribute(COOKIE_AT_TYPE);
                DefaultModification deleteCookieMod = new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, cookieAttr);
                ArrayList<Modification> deleteModLst = new ArrayList<Modification>();
                deleteModLst.add(deleteCookieMod);
                this.session.modify(this.config.getConfigEntryDn(), deleteModLst);
            }
            catch (Exception e) {
                LOG.warn("Failed to delete the cookie from the entry with Dn {}", this.config.getConfigEntryDn());
                LOG.warn("{}", e);
            }
        }
        LOG.info("resetting sync cookie");
        this.syncCookie = null;
        this.lastSavedCookie = null;
    }

    private void applyModDnOperation(SyncModifyDn modDnControl) throws Exception {
        SyncModifyDnType modDnType = modDnControl.getModDnType();
        Dn entryDn = new Dn(modDnControl.getEntryDn());
        switch (modDnType) {
            case MOVE: {
                LOG.debug("moving {} to the new parent {}", entryDn, (Object)modDnControl.getNewSuperiorDn());
                this.session.move(entryDn, new Dn(modDnControl.getNewSuperiorDn()));
                break;
            }
            case RENAME: {
                Rdn newRdn = new Rdn(modDnControl.getNewRdn());
                boolean deleteOldRdn = modDnControl.isDeleteOldRdn();
                LOG.debug("renaming the Dn {} with new Rdn {} and deleteOldRdn flag set to {}", new String[]{entryDn.getName(), newRdn.getName(), String.valueOf(deleteOldRdn)});
                this.session.rename(entryDn, newRdn, deleteOldRdn);
                break;
            }
            case MOVEANDRENAME: {
                Dn newParentDn = new Dn(modDnControl.getNewSuperiorDn());
                Rdn newRdn = new Rdn(modDnControl.getNewRdn());
                boolean deleteOldRdn = modDnControl.isDeleteOldRdn();
                LOG.debug("moveAndRename on the Dn {} with new newParent Dn {}, new Rdn {} and deleteOldRdn flag set to {}", new String[]{entryDn.getName(), newParentDn.getName(), newRdn.getName(), String.valueOf(deleteOldRdn)});
                this.session.moveAndRename(entryDn, newParentDn, newRdn, deleteOldRdn);
            }
        }
    }

    private void modify(Entry remoteEntry) throws Exception {
        Entry localEntry = this.session.lookup(remoteEntry.getDn());
        remoteEntry.removeAttributes(MOD_IGNORE_AT);
        ArrayList<Modification> mods = new ArrayList<Modification>();
        for (Attribute localAttr : localEntry) {
            DefaultModification mod;
            String attrId = localAttr.getId();
            Attribute remoteAttr = remoteEntry.get(attrId);
            if (remoteAttr != null) {
                mod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, remoteAttr);
                remoteEntry.remove(remoteAttr);
            } else {
                mod = new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, localAttr);
            }
            mods.add(mod);
        }
        if (remoteEntry.size() > 0) {
            Iterator<Attribute> itr = remoteEntry.iterator();
            while (itr.hasNext()) {
                mods.add(new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, itr.next()));
            }
        }
        this.session.modify(remoteEntry.getDn(), mods);
    }

    public void deleteEntries(List<byte[]> uuidList, boolean isRefreshPresent) throws Exception {
        int i;
        if (uuidList == null || uuidList.isEmpty()) {
            return;
        }
        for (byte[] uuid : uuidList) {
            LOG.info("uuid: {}", (Object)Strings.uuidToString(uuid));
        }
        if (isRefreshPresent) {
            LOG.debug("refresh present syncinfo list has {} UUIDs", uuidList.size());
            this._deleteEntries_(uuidList, isRefreshPresent);
            return;
        }
        int NODE_LIMIT = 10;
        int count = uuidList.size() / NODE_LIMIT;
        int startIndex = 0;
        for (i = 0; i < count; ++i) {
            startIndex = i * NODE_LIMIT;
            this._deleteEntries_(uuidList.subList(startIndex, startIndex + NODE_LIMIT), isRefreshPresent);
        }
        if (uuidList.size() % NODE_LIMIT != 0) {
            if (count > 0) {
                startIndex = i * NODE_LIMIT;
            }
            this._deleteEntries_(uuidList.subList(startIndex, uuidList.size()), isRefreshPresent);
        }
    }

    private void _deleteEntries_(List<byte[]> limitedUuidList, boolean isRefreshPresent) throws Exception {
        AbstractExprNode filter = null;
        int size = limitedUuidList.size();
        if (size == 1) {
            String uuid = Strings.uuidToString(limitedUuidList.get(0));
            filter = new EqualityNode<String>("entryUUID", new StringValue(uuid));
            if (isRefreshPresent) {
                filter = new NotNode(filter);
            }
        } else {
            filter = isRefreshPresent ? new AndNode() : new OrNode();
            for (int i = 0; i < size; ++i) {
                String uuid = Strings.uuidToString(limitedUuidList.get(i));
                AbstractExprNode uuidEqNode = new EqualityNode<String>("entryUUID", new StringValue(uuid));
                if (isRefreshPresent) {
                    uuidEqNode = new NotNode(uuidEqNode);
                    ((AndNode)filter).addNode(uuidEqNode);
                    continue;
                }
                ((OrNode)filter).addNode(uuidEqNode);
            }
        }
        Dn dn = new Dn(this.schemaManager, this.config.getBaseDn());
        LOG.debug("selecting entries to be deleted using filter {}", (Object)((Object)filter).toString());
        EntryFilteringCursor cursor = this.session.search(dn, SearchScope.SUBTREE, filter, AliasDerefMode.NEVER_DEREF_ALIASES, ENTRY_UUID_ATOP_SET);
        cursor.beforeFirst();
        while (cursor.next()) {
            Entry entry = (Entry)cursor.get();
            this.deleteRecursive(entry.getDn(), null);
        }
        cursor.close();
    }

    private void deleteRecursive(Dn rootDn, Map<Dn, EntryFilteringCursor> cursorMap) throws Exception {
        LOG.debug("searching for {}", (Object)rootDn.getName());
        EntryFilteringCursor cursor = null;
        try {
            if (cursorMap == null) {
                cursorMap = new HashMap<Dn, EntryFilteringCursor>();
            }
            if ((cursor = cursorMap.get(rootDn)) == null) {
                cursor = this.session.search(rootDn, SearchScope.ONELEVEL, ENTRY_UUID_PRESENCE_FILTER, AliasDerefMode.NEVER_DEREF_ALIASES, ENTRY_UUID_ATOP_SET);
                cursor.beforeFirst();
                LOG.debug("putting cursor for {}", (Object)rootDn.getName());
                cursorMap.put(rootDn, cursor);
            }
            if (!cursor.next()) {
                LOG.debug("deleting {}", (Object)rootDn.getName());
                cursorMap.remove(rootDn);
                cursor.close();
                this.session.delete(rootDn);
            } else {
                do {
                    Entry entry = (Entry)cursor.get();
                    this.deleteRecursive(entry.getDn(), cursorMap);
                } while (cursor.next());
                cursorMap.remove(rootDn);
                cursor.close();
                LOG.debug("deleting {}", (Object)rootDn.getName());
                this.session.delete(rootDn);
            }
        }
        catch (Exception e) {
            String msg = "Failed to delete child entries under the Dn " + rootDn.getName();
            LOG.error(msg, e);
            throw e;
        }
    }

    static {
        ENTRY_UUID_PRESENCE_FILTER = new PresenceNode("entryUUID");
        ENTRY_UUID_ATOP_SET = new HashSet<AttributeTypeOptions>();
    }

    private class RefresherThread
    extends Thread {
        private volatile boolean stop;

        public RefresherThread() {
            this.setDaemon(true);
        }

        public void run() {
            while (!this.stop) {
                LOG.debug("==================== Refresh Only ==========");
                try {
                    SyncReplConsumer.this.doSyncSearch(SynchronizationModeEnum.REFRESH_ONLY, false);
                    LOG.info("--------------------- Sleep for a little while ------------------");
                    Thread.sleep(SyncReplConsumer.this.config.getRefreshInterval());
                    LOG.debug("--------------------- syncing again ------------------");
                }
                catch (InterruptedException ie) {
                    LOG.warn("refresher thread interrupted");
                }
                catch (Exception e) {
                    LOG.error("Failed to sync with refresh only mode", e);
                }
            }
        }

        public void stopRefreshing() {
            this.stop = true;
            this.interrupt();
        }
    }
}

