/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.impl.ApproximateEvaluator;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.filter.LeafNode;
import org.apache.directory.shared.ldap.model.filter.SimpleNode;
import org.apache.directory.shared.ldap.model.schema.AttributeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApproximateCursor<V, ID extends Comparable<ID>>
extends AbstractIndexCursor<V, Entry, ID> {
    private static final String UNSUPPORTED_MSG = "ApproximateCursors only support positioning by element when a user index exists on the asserted attribute.";
    private final ApproximateEvaluator<V, ID> approximateEvaluator;
    private final IndexCursor<V, Entry, ID> userIdxCursor;
    private final IndexCursor<String, Entry, ID> ndnIdxCursor;
    private boolean available = false;

    public ApproximateCursor(Store<Entry, ID> db, ApproximateEvaluator<V, ID> approximateEvaluator) throws Exception {
        this.approximateEvaluator = approximateEvaluator;
        AttributeType attributeType = ((LeafNode)approximateEvaluator.getExpression()).getAttributeType();
        Value value = ((SimpleNode)approximateEvaluator.getExpression()).getValue();
        if (db.hasIndexOn(attributeType)) {
            Index<?, Entry, ID> index = db.getIndex(attributeType);
            this.userIdxCursor = index.forwardCursor(value.getValue());
            this.ndnIdxCursor = null;
        } else {
            this.ndnIdxCursor = db.getNdnIndex().forwardCursor();
            this.userIdxCursor = null;
        }
    }

    @Override
    public boolean available() {
        if (this.userIdxCursor != null) {
            return this.userIdxCursor.available();
        }
        return this.available;
    }

    @Override
    public void beforeValue(ID id, V value) throws Exception {
        this.checkNotClosed("beforeValue()");
        if (this.userIdxCursor == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        this.userIdxCursor.beforeValue(id, value);
    }

    @Override
    public void afterValue(ID id, V value) throws Exception {
        this.checkNotClosed("afterValue()");
        if (this.userIdxCursor == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        this.userIdxCursor.afterValue(id, value);
    }

    @Override
    public void before(IndexEntry<V, Entry, ID> element) throws Exception {
        this.checkNotClosed("before()");
        if (this.userIdxCursor == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        this.userIdxCursor.before((Entry)((Object)element));
    }

    @Override
    public void after(IndexEntry<V, Entry, ID> element) throws Exception {
        this.checkNotClosed("after()");
        if (this.userIdxCursor == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        this.userIdxCursor.after((Entry)((Object)element));
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.beforeFirst();
        } else {
            this.ndnIdxCursor.beforeFirst();
            this.available = false;
        }
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.afterLast();
        } else {
            this.ndnIdxCursor.afterLast();
            this.available = false;
        }
    }

    @Override
    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    @Override
    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    @Override
    public boolean previous() throws Exception {
        if (this.userIdxCursor != null) {
            return this.userIdxCursor.previous();
        }
        while (this.ndnIdxCursor.previous()) {
            this.checkNotClosed("previous()");
            IndexEntry candidate = (IndexEntry)this.ndnIdxCursor.get();
            if (!this.approximateEvaluator.evaluate(candidate)) continue;
            this.available = true;
            return true;
        }
        this.available = false;
        return false;
    }

    @Override
    public boolean next() throws Exception {
        if (this.userIdxCursor != null) {
            return this.userIdxCursor.next();
        }
        while (this.ndnIdxCursor.next()) {
            this.checkNotClosed("next()");
            IndexEntry candidate = (IndexEntry)this.ndnIdxCursor.get();
            if (!this.approximateEvaluator.evaluate(candidate)) continue;
            this.available = true;
            return true;
        }
        this.available = false;
        return false;
    }

    @Override
    public IndexEntry<V, Entry, ID> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.userIdxCursor != null) {
            return (IndexEntry)this.userIdxCursor.get();
        }
        if (this.available) {
            return (IndexEntry)this.ndnIdxCursor.get();
        }
        throw new InvalidCursorPositionException(I18n.err(I18n.ERR_708, new Object[0]));
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.userIdxCursor != null) {
            this.userIdxCursor.close();
        } else {
            this.ndnIdxCursor.close();
        }
    }
}

