/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.shared.ldap.model.filter.ScopeNode;
import org.apache.directory.shared.ldap.model.message.SearchScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneLevelScopeEvaluator<E, ID extends Comparable<ID>>
implements Evaluator<ScopeNode, E, ID> {
    private final ScopeNode node;
    private final ID baseId;
    private final boolean dereferencing;
    private final Store<E, ID> db;

    public OneLevelScopeEvaluator(Store<E, ID> db, ScopeNode node) throws Exception {
        this.node = node;
        if (node.getScope() != SearchScope.ONELEVEL) {
            throw new IllegalStateException(I18n.err(I18n.ERR_720, new Object[0]));
        }
        this.db = db;
        this.baseId = db.getEntryId(node.getBaseDn());
        this.dereferencing = node.getDerefAliases().isDerefInSearching() || node.getDerefAliases().isDerefAlways();
    }

    @Override
    public boolean evaluateId(ID candidate) throws Exception {
        boolean isChild = this.db.getOneLevelIndex().forward(this.baseId, candidate);
        if (!this.dereferencing) {
            return isChild;
        }
        if (null != this.db.getAliasIndex().reverseLookup(candidate)) {
            return false;
        }
        if (isChild) {
            return true;
        }
        return this.db.getOneAliasIndex().forward(this.baseId, candidate);
    }

    @Override
    public boolean evaluateEntry(E candidate) throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_721, new Object[0]));
    }

    @Override
    public boolean evaluate(IndexEntry<?, E, ID> candidate) throws Exception {
        boolean isChild = this.db.getOneLevelIndex().forward(this.baseId, candidate.getId());
        if (!this.dereferencing) {
            return isChild;
        }
        if (null != this.db.getAliasIndex().reverseLookup(candidate.getId())) {
            return false;
        }
        if (isChild) {
            return true;
        }
        return this.db.getOneAliasIndex().forward(this.baseId, candidate.getId());
    }

    @Override
    public ScopeNode getExpression() {
        return this.node;
    }

    public ID getBaseId() {
        return this.baseId;
    }

    public boolean isDereferencing() {
        return this.dereferencing;
    }
}

