/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.Grammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.kerberos.codec.KerberosMessageContainer;
import org.apache.directory.shared.kerberos.codec.KerberosMessageStatesEnum;
import org.apache.directory.shared.kerberos.codec.apRep.ApRepContainer;
import org.apache.directory.shared.kerberos.codec.apReq.ApReqContainer;
import org.apache.directory.shared.kerberos.codec.asRep.AsRepContainer;
import org.apache.directory.shared.kerberos.codec.asReq.AsReqContainer;
import org.apache.directory.shared.kerberos.codec.krbCred.KrbCredContainer;
import org.apache.directory.shared.kerberos.codec.krbError.KrbErrorContainer;
import org.apache.directory.shared.kerberos.codec.krbPriv.KrbPrivContainer;
import org.apache.directory.shared.kerberos.codec.krbSafe.KrbSafeContainer;
import org.apache.directory.shared.kerberos.codec.tgsRep.TgsRepContainer;
import org.apache.directory.shared.kerberos.codec.tgsReq.TgsReqContainer;
import org.apache.directory.shared.kerberos.messages.ApRep;
import org.apache.directory.shared.kerberos.messages.ApReq;
import org.apache.directory.shared.kerberos.messages.AsRep;
import org.apache.directory.shared.kerberos.messages.AsReq;
import org.apache.directory.shared.kerberos.messages.KrbCred;
import org.apache.directory.shared.kerberos.messages.KrbError;
import org.apache.directory.shared.kerberos.messages.KrbPriv;
import org.apache.directory.shared.kerberos.messages.KrbSafe;
import org.apache.directory.shared.kerberos.messages.TgsRep;
import org.apache.directory.shared.kerberos.messages.TgsReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KerberosMessageGrammar
extends AbstractGrammar<KerberosMessageContainer> {
    static final Logger LOG = LoggerFactory.getLogger(KerberosMessageGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar<KerberosMessageContainer> instance = new KerberosMessageGrammar();
    Asn1Decoder kerberosDecoder = new Asn1Decoder();

    private KerberosMessageGrammar() {
        this.setName(KerberosMessageGrammar.class.getName());
        this.transitions = new GrammarTransition[KerberosMessageStatesEnum.LAST_KERBEROS_MESSAGE_STATE.ordinal()][256];
        this.transitions[KerberosMessageStatesEnum.START_STATE.ordinal()][106] = new GrammarTransition<KerberosMessageContainer>(KerberosMessageStatesEnum.START_STATE, KerberosMessageStatesEnum.AS_REQ_STATE, 106, new DecodeKerberosMessage());
        this.transitions[KerberosMessageStatesEnum.START_STATE.ordinal()][107] = new GrammarTransition<KerberosMessageContainer>(KerberosMessageStatesEnum.START_STATE, KerberosMessageStatesEnum.AS_REP_TAG_STATE, 107, new DecodeKerberosMessage());
        this.transitions[KerberosMessageStatesEnum.START_STATE.ordinal()][108] = new GrammarTransition<KerberosMessageContainer>(KerberosMessageStatesEnum.START_STATE, KerberosMessageStatesEnum.TGS_REQ_TAG_STATE, 108, new DecodeKerberosMessage());
        this.transitions[KerberosMessageStatesEnum.START_STATE.ordinal()][109] = new GrammarTransition<KerberosMessageContainer>(KerberosMessageStatesEnum.START_STATE, KerberosMessageStatesEnum.TGS_REP_TAG_STATE, 109, new DecodeKerberosMessage());
        this.transitions[KerberosMessageStatesEnum.START_STATE.ordinal()][110] = new GrammarTransition<KerberosMessageContainer>(KerberosMessageStatesEnum.START_STATE, KerberosMessageStatesEnum.AP_REQ_TAG_STATE, 110, new DecodeKerberosMessage());
        this.transitions[KerberosMessageStatesEnum.START_STATE.ordinal()][111] = new GrammarTransition<KerberosMessageContainer>(KerberosMessageStatesEnum.START_STATE, KerberosMessageStatesEnum.AP_REP_TAG_STATE, 111, new DecodeKerberosMessage());
        this.transitions[KerberosMessageStatesEnum.START_STATE.ordinal()][116] = new GrammarTransition<KerberosMessageContainer>(KerberosMessageStatesEnum.START_STATE, KerberosMessageStatesEnum.KRB_SAFE_STATE, 116, new DecodeKerberosMessage());
        this.transitions[KerberosMessageStatesEnum.START_STATE.ordinal()][117] = new GrammarTransition<KerberosMessageContainer>(KerberosMessageStatesEnum.START_STATE, KerberosMessageStatesEnum.KRB_PRIV_STATE, 117, new DecodeKerberosMessage());
        this.transitions[KerberosMessageStatesEnum.START_STATE.ordinal()][118] = new GrammarTransition<KerberosMessageContainer>(KerberosMessageStatesEnum.START_STATE, KerberosMessageStatesEnum.KRB_CRED_STATE, 118, new DecodeKerberosMessage());
        this.transitions[KerberosMessageStatesEnum.START_STATE.ordinal()][126] = new GrammarTransition<KerberosMessageContainer>(KerberosMessageStatesEnum.START_STATE, KerberosMessageStatesEnum.KRB_ERROR_STATE, 126, new DecodeKerberosMessage());
    }

    public static Grammar<KerberosMessageContainer> getInstance() {
        return instance;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DecodeKerberosMessage
    extends GrammarAction<KerberosMessageContainer> {
        private DecodeKerberosMessage() {
        }

        @Override
        public void action(KerberosMessageContainer kerberosMessageContainer) throws DecoderException {
            ByteBuffer stream = kerberosMessageContainer.getStream();
            stream.rewind();
            TLV tlv = kerberosMessageContainer.getCurrentTLV();
            kerberosMessageContainer.setGrammarEndAllowed(true);
            switch (tlv.getTag()) {
                case 106: {
                    AsReqContainer asReqContainer = new AsReqContainer(stream);
                    KerberosMessageGrammar.this.kerberosDecoder.decode(stream, asReqContainer);
                    AsReq asReq = asReqContainer.getAsReq();
                    kerberosMessageContainer.setMessage(asReq);
                    break;
                }
                case 107: {
                    AsRepContainer asRepContainer = new AsRepContainer(stream);
                    KerberosMessageGrammar.this.kerberosDecoder.decode(stream, asRepContainer);
                    AsRep asRep = asRepContainer.getAsRep();
                    kerberosMessageContainer.setMessage(asRep);
                    break;
                }
                case 108: {
                    TgsReqContainer tgsReqContainer = new TgsReqContainer(stream);
                    KerberosMessageGrammar.this.kerberosDecoder.decode(stream, tgsReqContainer);
                    TgsReq tgsReq = tgsReqContainer.getTgsReq();
                    kerberosMessageContainer.setMessage(tgsReq);
                    break;
                }
                case 109: {
                    TgsRepContainer tgsRepContainer = new TgsRepContainer(stream);
                    KerberosMessageGrammar.this.kerberosDecoder.decode(stream, tgsRepContainer);
                    TgsRep tgsRep = tgsRepContainer.getTgsRep();
                    kerberosMessageContainer.setMessage(tgsRep);
                    break;
                }
                case 110: {
                    ApReqContainer apReqContainer = new ApReqContainer(stream);
                    KerberosMessageGrammar.this.kerberosDecoder.decode(stream, apReqContainer);
                    ApReq apReq = apReqContainer.getApReq();
                    kerberosMessageContainer.setMessage(apReq);
                    break;
                }
                case 111: {
                    ApRepContainer apRepContainer = new ApRepContainer(stream);
                    KerberosMessageGrammar.this.kerberosDecoder.decode(stream, apRepContainer);
                    ApRep apRep = apRepContainer.getApRep();
                    kerberosMessageContainer.setMessage(apRep);
                    break;
                }
                case 116: {
                    KrbSafeContainer krbSafeContainer = new KrbSafeContainer(stream);
                    KerberosMessageGrammar.this.kerberosDecoder.decode(stream, krbSafeContainer);
                    KrbSafe krbSafe = krbSafeContainer.getKrbSafe();
                    kerberosMessageContainer.setMessage(krbSafe);
                    break;
                }
                case 117: {
                    KrbPrivContainer krbPrivContainer = new KrbPrivContainer(stream);
                    KerberosMessageGrammar.this.kerberosDecoder.decode(stream, krbPrivContainer);
                    KrbPriv krbPriv = krbPrivContainer.getKrbPriv();
                    kerberosMessageContainer.setMessage(krbPriv);
                    break;
                }
                case 118: {
                    KrbCredContainer krbCredContainer = new KrbCredContainer(stream);
                    KerberosMessageGrammar.this.kerberosDecoder.decode(stream, krbCredContainer);
                    KrbCred krbCred = krbCredContainer.getKrbCred();
                    kerberosMessageContainer.setMessage(krbCred);
                    break;
                }
                case 126: {
                    KrbErrorContainer krbErrorContainer = new KrbErrorContainer(stream);
                    KerberosMessageGrammar.this.kerberosDecoder.decode(stream, krbErrorContainer);
                    KrbError krbError = krbErrorContainer.getKrbError();
                    kerberosMessageContainer.setMessage(krbError);
                }
            }
            if (IS_DEBUG) {
                LOG.debug("Decoded KerberosMessage {}", kerberosMessageContainer.getMessage());
            }
        }
    }
}

