/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.encKrbPrivPart.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.kerberos.codec.encKrbPrivPart.EncKrbPrivPartContainer;
import org.apache.directory.shared.kerberos.components.EncKrbPrivPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncKrbPrivPartInit
extends GrammarAction<EncKrbPrivPartContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(EncKrbPrivPartInit.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public EncKrbPrivPartInit() {
        super("Creates a EncKrbPrivPart instance");
    }

    @Override
    public void action(EncKrbPrivPartContainer encKrbPrivPartContainer) throws DecoderException {
        TLV tlv = encKrbPrivPartContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err(I18n.ERR_04066, new Object[0]));
            throw new DecoderException(I18n.err(I18n.ERR_04067, new Object[0]));
        }
        EncKrbPrivPart encKrbPrivPart = new EncKrbPrivPart();
        encKrbPrivPartContainer.setEncKrbPrivPart(encKrbPrivPart);
        if (IS_DEBUG) {
            LOG.debug("EncKrbPrivPart created");
        }
    }
}

