/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.encryptionKey.actions;

import org.apache.directory.shared.asn1.actions.AbstractReadInteger;
import org.apache.directory.shared.kerberos.codec.encryptionKey.EncryptionKeyContainer;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreKeyType
extends AbstractReadInteger<EncryptionKeyContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreKeyType.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreKeyType() {
        super("EncryptionKey's keytype");
    }

    @Override
    protected void setIntegerValue(int value, EncryptionKeyContainer encryptionKeyContainer) {
        EncryptionKey encKey = encryptionKeyContainer.getEncryptionKey();
        EncryptionType encryptionType = EncryptionType.getTypeByValue(value);
        encKey.setKeyType(encryptionType);
        if (IS_DEBUG) {
            LOG.debug("keytype : {}", (Object)encryptionType);
        }
    }
}

