/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.krbError.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.kerberos.codec.krbError.KrbErrorContainer;
import org.apache.directory.shared.kerberos.messages.KrbError;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreEText
extends GrammarAction<KrbErrorContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreEText.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreEText() {
        super("KRB-ERROR etext");
    }

    @Override
    public final void action(KrbErrorContainer krbErrorContainer) throws DecoderException {
        TLV tlv = krbErrorContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err(I18n.ERR_04066, new Object[0]));
            throw new DecoderException(I18n.err(I18n.ERR_04067, new Object[0]));
        }
        Value value = tlv.getValue();
        String eText = Strings.utf8ToString(value.getData());
        KrbError krbError = krbErrorContainer.getKrbError();
        krbError.setEText(eText);
        if (IS_DEBUG) {
            LOG.debug("eText: " + eText);
        }
        krbErrorContainer.setGrammarEndAllowed(true);
    }
}

