/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.controls.syncrepl_impl;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.Asn1Object;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.util.Asn1StringUtils;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.ControlDecorator;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.extras.controls.SyncModifyDn;
import org.apache.directory.shared.ldap.extras.controls.SyncModifyDnImpl;
import org.apache.directory.shared.ldap.extras.controls.SyncModifyDnType;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncModifyDnContainer;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncModifyDnTags;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncModifyDnDecorator
extends ControlDecorator<SyncModifyDn>
implements SyncModifyDn {
    private String entryDn;
    private String newSuperiorDn;
    private String newRdn;
    private boolean deleteOldRdn = false;
    private SyncModifyDnType modDnType;
    private int syncModDnSeqLength;
    private int renameLen = 0;
    private int moveAndRenameLen = 0;
    private Asn1Decoder decoder = new Asn1Decoder();

    public SyncModifyDnDecorator(LdapApiService codec) {
        super(codec, new SyncModifyDnImpl());
    }

    public SyncModifyDnDecorator(LdapApiService codec, SyncModifyDnType type) {
        this(codec);
        this.modDnType = type;
    }

    public SyncModifyDnDecorator(LdapApiService codec, SyncModifyDn control) {
        super(codec, control);
    }

    @Override
    public int computeLength() {
        this.syncModDnSeqLength = 1 + TLV.getNbBytes(this.entryDn.length()) + this.entryDn.length();
        switch (this.modDnType) {
            case MOVE: {
                int moveLen = 1 + TLV.getNbBytes(this.newSuperiorDn.length()) + this.newSuperiorDn.length();
                this.syncModDnSeqLength += moveLen;
                break;
            }
            case RENAME: {
                this.renameLen = 1 + TLV.getNbBytes(this.newRdn.length()) + this.newRdn.length();
                this.renameLen += 3;
                this.syncModDnSeqLength += 1 + TLV.getNbBytes(this.renameLen) + this.renameLen;
                break;
            }
            case MOVEANDRENAME: {
                this.moveAndRenameLen = 1 + TLV.getNbBytes(this.newSuperiorDn.length()) + this.newSuperiorDn.length();
                this.moveAndRenameLen += 1 + TLV.getNbBytes(this.newRdn.length()) + this.newRdn.length();
                this.moveAndRenameLen += 3;
                this.syncModDnSeqLength += 1 + TLV.getNbBytes(this.moveAndRenameLen) + this.moveAndRenameLen;
            }
        }
        this.valueLength = 1 + TLV.getNbBytes(this.syncModDnSeqLength) + this.syncModDnSeqLength;
        return this.valueLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_04023, new Object[0]));
        }
        buffer.put(UniversalTag.SEQUENCE.getValue());
        buffer.put(TLV.getBytes(this.syncModDnSeqLength));
        Value.encode(buffer, this.entryDn);
        switch (this.modDnType) {
            case MOVE: {
                buffer.put((byte)SyncModifyDnTags.MOVE_TAG.getValue());
                buffer.put(TLV.getBytes(this.newSuperiorDn.length()));
                buffer.put(Asn1StringUtils.getBytesUtf8(this.newSuperiorDn));
                break;
            }
            case RENAME: {
                buffer.put((byte)SyncModifyDnTags.RENAME_TAG.getValue());
                buffer.put(TLV.getBytes(this.renameLen));
                Value.encode(buffer, this.newRdn);
                Value.encode(buffer, this.deleteOldRdn);
                break;
            }
            case MOVEANDRENAME: {
                buffer.put((byte)SyncModifyDnTags.MOVEANDRENAME_TAG.getValue());
                buffer.put(TLV.getBytes(this.moveAndRenameLen));
                Value.encode(buffer, this.newSuperiorDn);
                Value.encode(buffer, this.newRdn);
                Value.encode(buffer, this.deleteOldRdn);
            }
        }
        return buffer;
    }

    @Override
    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                buffer.put(UniversalTag.SEQUENCE.getValue());
                buffer.put(TLV.getBytes(this.syncModDnSeqLength));
                Value.encode(buffer, this.entryDn);
                switch (this.modDnType) {
                    case MOVE: {
                        buffer.put((byte)SyncModifyDnTags.MOVE_TAG.getValue());
                        buffer.put(TLV.getBytes(this.newSuperiorDn.length()));
                        buffer.put(Asn1StringUtils.getBytesUtf8(this.newSuperiorDn));
                        break;
                    }
                    case RENAME: {
                        buffer.put((byte)SyncModifyDnTags.RENAME_TAG.getValue());
                        buffer.put(TLV.getBytes(this.renameLen));
                        Value.encode(buffer, this.newRdn);
                        Value.encode(buffer, this.deleteOldRdn);
                        break;
                    }
                    case MOVEANDRENAME: {
                        buffer.put((byte)SyncModifyDnTags.MOVEANDRENAME_TAG.getValue());
                        buffer.put(TLV.getBytes(this.moveAndRenameLen));
                        Value.encode(buffer, this.newSuperiorDn);
                        Value.encode(buffer, this.newRdn);
                        Value.encode(buffer, this.deleteOldRdn);
                    }
                }
                this.value = buffer.array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    @Override
    public String getEntryDn() {
        return this.entryDn;
    }

    @Override
    public void setEntryDn(String entryDn) {
        this.entryDn = entryDn;
    }

    @Override
    public String getNewSuperiorDn() {
        return this.newSuperiorDn;
    }

    @Override
    public void setNewSuperiorDn(String newSuperiorDn) {
        this.newSuperiorDn = newSuperiorDn;
    }

    @Override
    public String getNewRdn() {
        return this.newRdn;
    }

    @Override
    public void setNewRdn(String newRdn) {
        this.newRdn = newRdn;
    }

    @Override
    public boolean isDeleteOldRdn() {
        return this.deleteOldRdn;
    }

    @Override
    public void setDeleteOldRdn(boolean deleteOldRdn) {
        this.deleteOldRdn = deleteOldRdn;
    }

    @Override
    public SyncModifyDnType getModDnType() {
        return this.modDnType;
    }

    @Override
    public void setModDnType(SyncModifyDnType modDnType) {
        if (this.modDnType != null) {
            throw new IllegalStateException("cannot overwrite the existing modDnType value");
        }
        this.modDnType = modDnType;
    }

    @Override
    public Asn1Object decode(byte[] controlBytes) throws DecoderException {
        ByteBuffer bb = ByteBuffer.wrap(controlBytes);
        SyncModifyDnContainer container = new SyncModifyDnContainer(this);
        this.decoder.decode(bb, container);
        return this;
    }
}

