/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.syncrepl_impl;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.Asn1Object;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ControlDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.controls.SyncDoneValue;
import org.apache.directory.api.ldap.extras.controls.SyncDoneValueImpl;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncDoneValueContainer;
import org.apache.directory.api.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncDoneValueDecorator
extends ControlDecorator<SyncDoneValue>
implements SyncDoneValue {
    private int syncDoneValueLength;
    private static final Asn1Decoder decoder = new Asn1Decoder();

    public SyncDoneValueDecorator(LdapApiService codec) {
        super(codec, new SyncDoneValueImpl());
    }

    public SyncDoneValueDecorator(LdapApiService codec, SyncDoneValue control) {
        super(codec, control);
    }

    @Override
    public int computeLength() {
        if (this.getCookie() != null) {
            this.syncDoneValueLength = 1 + TLV.getNbBytes(this.getCookie().length) + this.getCookie().length;
        }
        if (this.isRefreshDeletes()) {
            this.syncDoneValueLength += 3;
        }
        this.valueLength = 1 + TLV.getNbBytes(this.syncDoneValueLength) + this.syncDoneValueLength;
        return this.valueLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_04023, new Object[0]));
        }
        buffer.put(UniversalTag.SEQUENCE.getValue());
        buffer.put(TLV.getBytes(this.syncDoneValueLength));
        if (this.getCookie() != null) {
            BerValue.encode(buffer, this.getCookie());
        }
        if (this.isRefreshDeletes()) {
            BerValue.encode(buffer, this.isRefreshDeletes());
        }
        return buffer;
    }

    @Override
    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                buffer.put(UniversalTag.SEQUENCE.getValue());
                buffer.put(TLV.getBytes(this.syncDoneValueLength));
                if (this.getCookie() != null) {
                    BerValue.encode(buffer, this.getCookie());
                }
                if (this.isRefreshDeletes()) {
                    BerValue.encode(buffer, this.isRefreshDeletes());
                }
                this.value = buffer.array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    @Override
    public byte[] getCookie() {
        return ((SyncDoneValue)this.getDecorated()).getCookie();
    }

    @Override
    public void setCookie(byte[] cookie) {
        if (!Strings.isEmpty(cookie)) {
            byte[] copy = new byte[cookie.length];
            System.arraycopy(cookie, 0, copy, 0, cookie.length);
            ((SyncDoneValue)this.getDecorated()).setCookie(copy);
        } else {
            ((SyncDoneValue)this.getDecorated()).setCookie(null);
        }
    }

    @Override
    public boolean isRefreshDeletes() {
        return ((SyncDoneValue)this.getDecorated()).isRefreshDeletes();
    }

    @Override
    public void setRefreshDeletes(boolean refreshDeletes) {
        ((SyncDoneValue)this.getDecorated()).setRefreshDeletes(refreshDeletes);
    }

    @Override
    public Asn1Object decode(byte[] controlBytes) throws DecoderException {
        ByteBuffer bb = ByteBuffer.wrap(controlBytes);
        SyncDoneValueContainer container = new SyncDoneValueContainer(this.getCodecService(), this);
        decoder.decode(bb, container);
        return this;
    }
}

