/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.interceptor.context;

import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.directory.api.ldap.model.message.UnbindRequest;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.OperationEnum;
import org.apache.directory.server.core.api.interceptor.context.AbstractOperationContext;

public class UnbindOperationContext
extends AbstractOperationContext {
    public UnbindOperationContext(CoreSession session) {
        super(session, session.getEffectivePrincipal().getDn());
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.UNBIND));
        }
    }

    public UnbindOperationContext(CoreSession session, UnbindRequest unbindRequest) {
        super(session, session.getEffectivePrincipal().getDn());
        this.setRequestControls(unbindRequest.getControls());
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.UNBIND));
        }
    }

    @Override
    public String getName() {
        return MessageTypeEnum.UNBIND_REQUEST.name();
    }

    public String toString() {
        return "UnbindContext for Dn '" + this.getDn().getName() + "'";
    }
}

