/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm;

import java.io.IOException;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmptyIndexCursor<K>
extends AbstractIndexCursor<K> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger("CURSOR");
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();

    public EmptyIndexCursor() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating EmptyIndexCursor {}", (Object)this);
        }
    }

    @Override
    public void before(IndexEntry<K, String> element) throws LdapException, CursorException, IOException {
        this.checkNotClosed("before()");
    }

    @Override
    protected String getUnsupportedMessage() {
        return "Unsupported operation";
    }

    @Override
    public void after(IndexEntry<K, String> element) throws LdapException, CursorException, IOException {
        this.checkNotClosed("after()");
    }

    @Override
    public void beforeFirst() throws LdapException, CursorException, IOException {
        this.checkNotClosed("beforeFirst()");
    }

    @Override
    public void afterLast() throws LdapException, CursorException, IOException {
        this.checkNotClosed("afterLast()");
    }

    @Override
    public boolean first() throws LdapException, CursorException, IOException {
        this.checkNotClosed("first()");
        return false;
    }

    @Override
    public boolean last() throws LdapException, CursorException, IOException {
        this.checkNotClosed("last()");
        return false;
    }

    @Override
    public boolean previous() throws LdapException, CursorException, IOException {
        this.checkNotClosed("previous()");
        return false;
    }

    @Override
    public boolean next() throws LdapException, CursorException, IOException {
        this.checkNotClosed("next()");
        return false;
    }

    @Override
    public IndexEntry<K, String> get() throws CursorException, IOException {
        this.checkNotClosed("get()");
        throw new InvalidCursorPositionException(I18n.err(I18n.ERR_703, new Object[0]));
    }

    public void afterValue(String id, K indexValue) throws Exception {
        this.checkNotClosed("after()");
    }

    public void beforeValue(String id, K indexValue) throws Exception {
        this.checkNotClosed("after()");
    }

    @Override
    public void close() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing EmptyIndexCursor {}", (Object)this);
        }
        super.close();
    }

    @Override
    public void close(Exception cause) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing EmptyIndexCursor {}", (Object)this);
        }
        super.close(cause);
    }
}

