/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.api;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.decorators.SingleReplyRequestDecorator;
import org.apache.directory.api.ldap.model.exception.MessageException;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.directory.api.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedRequestDecorator<Q extends ExtendedRequest<P>, P extends ExtendedResponse>
extends SingleReplyRequestDecorator<Q, P>
implements ExtendedRequest<P> {
    private int extendedRequestLength;
    private byte[] requestNameBytes;
    protected byte[] requestValue;

    public ExtendedRequestDecorator(LdapApiService codec, Q decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public void setExtendedRequestLength(int extendedRequestLength) {
        this.extendedRequestLength = extendedRequestLength;
    }

    public int getExtendedRequestLength() {
        return this.extendedRequestLength;
    }

    public byte[] getRequestNameBytes() {
        return this.requestNameBytes;
    }

    public void setRequestNameBytes(byte[] requestNameBytes) {
        this.requestNameBytes = requestNameBytes;
    }

    @Override
    public String getRequestName() {
        return ((ExtendedRequest)this.getDecorated()).getRequestName();
    }

    @Override
    public ExtendedRequest<P> setRequestName(String oid) {
        ((ExtendedRequest)this.getDecorated()).setRequestName(oid);
        return this;
    }

    public byte[] getRequestValue() {
        return this.requestValue;
    }

    public void setRequestValue(byte[] requestValue) {
        this.requestValue = requestValue;
    }

    @Override
    public ExtendedRequest<P> setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    @Override
    public ExtendedRequest<P> addControl(Control control) throws MessageException {
        return (ExtendedRequest)super.addControl(control);
    }

    @Override
    public ExtendedRequest<P> addAllControls(Control[] controls) throws MessageException {
        return (ExtendedRequest)super.addAllControls(controls);
    }

    @Override
    public ExtendedRequest<P> removeControl(Control control) throws MessageException {
        return (ExtendedRequest)super.removeControl(control);
    }

    @Override
    public int computeLength() {
        byte[] requestNameBytes = Strings.getBytesUtf8(this.getRequestName());
        this.setRequestNameBytes(requestNameBytes);
        int extendedRequestLength = 1 + TLV.getNbBytes(requestNameBytes.length) + requestNameBytes.length;
        if (this.getRequestValue() != null) {
            extendedRequestLength += 1 + TLV.getNbBytes(this.getRequestValue().length) + this.getRequestValue().length;
        }
        this.setExtendedRequestLength(extendedRequestLength);
        return 1 + TLV.getNbBytes(extendedRequestLength) + extendedRequestLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)119);
            buffer.put(TLV.getBytes(this.getExtendedRequestLength()));
            if (this.getRequestNameBytes() == null) {
                throw new EncoderException(I18n.err(I18n.ERR_04043, new Object[0]));
            }
            buffer.put((byte)-128);
            buffer.put(TLV.getBytes(this.getRequestNameBytes().length));
            if (this.getRequestNameBytes().length != 0) {
                buffer.put(this.getRequestNameBytes());
            }
            if (this.getRequestValue() != null) {
                buffer.put((byte)-127);
                buffer.put(TLV.getBytes(this.getRequestValue().length));
                if (this.getRequestValue().length != 0) {
                    buffer.put(this.getRequestValue());
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_04005, new Object[0]));
        }
        return buffer;
    }
}

