/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.compareRequest;

import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.CompareRequestDecorator;
import org.apache.directory.api.ldap.model.message.CompareRequest;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreCompareRequestAssertionValue
extends GrammarAction<LdapMessageContainer<CompareRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreCompareRequestAssertionValue.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreCompareRequestAssertionValue() {
        super("Store CompareRequest assertion value");
    }

    @Override
    public void action(LdapMessageContainer<CompareRequestDecorator> container) {
        CompareRequest compareRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            compareRequest.setAssertionValue("");
        } else if (container.isBinary(compareRequest.getAttributeId())) {
            compareRequest.setAssertionValue(tlv.getValue().getData());
            if (IS_DEBUG) {
                LOG.debug("Comparing attribute value {}", (Object)Strings.dumpBytes(compareRequest.getAssertionValue().getBytes()));
            }
        } else {
            compareRequest.setAssertionValue(Strings.utf8ToString(tlv.getValue().getData()));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Comparing attribute value {}", (Object)compareRequest.getAssertionValue());
            }
        }
        container.setGrammarEndAllowed(true);
    }
}

