/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.extras.extended.PwdModifyResponse;
import org.apache.directory.api.ldap.model.message.ExtendedResponseImpl;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.util.Strings;

public class PwdModifyResponseImpl
extends ExtendedResponseImpl
implements PwdModifyResponse {
    private byte[] genPassword;

    public PwdModifyResponseImpl(int messageId, ResultCodeEnum rcode) {
        super(messageId, "1.3.6.1.4.1.4203.1.11.1");
        switch (rcode) {
            case SUCCESS: {
                break;
            }
            case OPERATIONS_ERROR: {
                break;
            }
            case INSUFFICIENT_ACCESS_RIGHTS: {
                break;
            }
            default: {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_04166, new Object[]{ResultCodeEnum.SUCCESS, ResultCodeEnum.OPERATIONS_ERROR, ResultCodeEnum.INSUFFICIENT_ACCESS_RIGHTS}));
            }
        }
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(rcode);
    }

    public PwdModifyResponseImpl(int messageId) {
        super(messageId, "1.3.6.1.4.1.4203.1.11.1");
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
    }

    public PwdModifyResponseImpl() {
        super("1.3.6.1.4.1.4203.1.11.1");
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
    }

    @Override
    public byte[] getGenPassword() {
        return this.genPassword;
    }

    public void setGenPassword(byte[] genPassword) {
        this.genPassword = genPassword;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PwdModifyResponse :");
        sb.append("\n    genPassword : ");
        if (this.genPassword != null) {
            sb.append(Strings.utf8ToString(this.genPassword));
        } else {
            sb.append("null");
        }
        return sb.toString();
    }
}

