/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.util.Comparator;
import org.apache.directory.mavibot.btree.BTreeTypeEnum;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.TupleCursor;
import org.apache.directory.mavibot.btree.ValueCursor;
import org.apache.directory.mavibot.btree.exception.KeyNotFoundException;
import org.apache.directory.mavibot.btree.serializer.ElementSerializer;

public interface BTree<K, V> {
    public static final int DEFAULT_PAGE_SIZE = 16;
    public static final int DEFAULT_WRITE_BUFFER_SIZE = 1024000;
    public static final long DEFAULT_READ_TIMEOUT = 10000L;
    public static final boolean ALLOW_DUPLICATES = true;
    public static final boolean FORBID_DUPLICATES = false;

    public void init() throws IOException;

    public void close() throws IOException;

    public void setPageSize(int var1);

    public int getPageSize();

    public V insert(K var1, V var2) throws IOException;

    public Tuple<K, V> delete(K var1) throws IOException;

    public Tuple<K, V> delete(K var1, V var2) throws IOException;

    public V get(K var1) throws IOException, KeyNotFoundException;

    public Page<K, V> getRootPage(long var1) throws IOException, KeyNotFoundException;

    public Page<K, V> getRootPage();

    public ValueCursor<V> getValues(K var1) throws IOException, KeyNotFoundException;

    public V get(long var1, K var3) throws IOException, KeyNotFoundException;

    public boolean hasKey(K var1) throws IOException;

    public boolean hasKey(long var1, K var3) throws IOException, KeyNotFoundException;

    public boolean contains(K var1, V var2) throws IOException;

    public boolean contains(long var1, K var3, V var4) throws IOException, KeyNotFoundException;

    public TupleCursor<K, V> browse() throws IOException;

    public TupleCursor<K, V> browse(long var1) throws IOException, KeyNotFoundException;

    public TupleCursor<K, V> browseFrom(K var1) throws IOException;

    public TupleCursor<K, V> browseFrom(long var1, K var3) throws IOException, KeyNotFoundException;

    public Comparator<K> getComparator();

    public void setKeySerializer(ElementSerializer<K> var1);

    public void setValueSerializer(ElementSerializer<V> var1);

    public void flush() throws IOException;

    public long getReadTimeOut();

    public void setReadTimeOut(long var1);

    public String getName();

    public void setName(String var1);

    public int getWriteBufferSize();

    public void setWriteBufferSize(int var1);

    public ElementSerializer<K> getKeySerializer();

    public String getKeySerializerFQCN();

    public ElementSerializer<V> getValueSerializer();

    public String getValueSerializerFQCN();

    public long getRevision();

    public long getNbElems();

    public boolean isAllowDuplicates();

    public void setAllowDuplicates(boolean var1);

    public BTreeTypeEnum getType();

    public void beginTransaction();

    public void commit();

    public void rollback();
}

