/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.directory.mavibot.btree.AbstractPage;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.ParentPos;
import org.apache.directory.mavibot.btree.ReadTransaction;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.ValueHolder;
import org.apache.directory.mavibot.btree.exception.EndOfFileExceededException;

public class TupleCursor<K, V> {
    private static final int BEFORE_FIRST = -1;
    private static final int AFTER_LAST = -2;
    protected ParentPos<K, V>[] stack;
    protected int depth = 0;
    protected ReadTransaction<K, V> transaction;
    protected Tuple<K, V> tuple = new Tuple();

    public TupleCursor(ReadTransaction<K, V> transaction, ParentPos<K, V>[] stack, int depth) {
        this.transaction = transaction;
        this.stack = stack;
        this.depth = depth;
    }

    public void afterLast() throws IOException {
        if (this.stack == null || this.stack.length == 0) {
            return;
        }
        Page child = null;
        for (int i = 0; i < this.depth; ++i) {
            ParentPos<K, V> parentPos = this.stack[i];
            if (child != null) {
                parentPos.page = child;
                parentPos.pos = child.getNbElems();
            } else {
                parentPos.pos = parentPos.page.getNbElems();
            }
            child = ((AbstractPage)parentPos.page).getPage(parentPos.pos);
        }
        ParentPos<K, V> parentPos = this.stack[this.depth];
        if (child == null) {
            parentPos.pos = parentPos.page.getNbElems() - 1;
        } else {
            parentPos.page = child;
            parentPos.pos = child.getNbElems() - 1;
        }
        parentPos.valueCursor = ((AbstractPage)parentPos.page).getValue(parentPos.pos).getCursor();
        parentPos.valueCursor.afterLast();
        parentPos.pos = -2;
    }

    public void beforeFirst() throws IOException {
        if (this.stack == null || this.stack.length == 0) {
            return;
        }
        Page child = null;
        for (int i = 0; i < this.depth; ++i) {
            ParentPos<K, V> parentPos = this.stack[i];
            parentPos.pos = 0;
            if (child != null) {
                parentPos.page = child;
            }
            child = ((AbstractPage)parentPos.page).getPage(0);
        }
        ParentPos<K, V> parentPos = this.stack[this.depth];
        parentPos.pos = -1;
        if (child != null) {
            parentPos.page = child;
        }
        if (parentPos.valueCursor != null) {
            parentPos.valueCursor = ((AbstractPage)parentPos.page).getValue(0).getCursor();
            parentPos.valueCursor.beforeFirst();
        }
    }

    public boolean hasNext() throws EndOfFileExceededException, IOException {
        if (this.stack == null || this.stack.length == 0) {
            return false;
        }
        ParentPos<K, V> parentPos = this.stack[this.depth];
        if (parentPos.page == null) {
            return false;
        }
        if (parentPos.pos == -2) {
            return false;
        }
        if (parentPos.pos < parentPos.page.getNbElems() - 1) {
            return true;
        }
        if (parentPos.valueCursor.hasNext()) {
            return true;
        }
        for (int currentDepth = this.depth - 1; currentDepth >= 0; --currentDepth) {
            parentPos = this.stack[currentDepth];
            if (parentPos.pos >= parentPos.page.getNbElems()) continue;
            return true;
        }
        return false;
    }

    public Tuple<K, V> next() throws EndOfFileExceededException, IOException {
        if (this.stack == null || this.stack.length == 0) {
            throw new NoSuchElementException("No tuple present");
        }
        ParentPos<K, V> parentPos = this.stack[this.depth];
        if (parentPos.page == null || parentPos.pos == -2) {
            throw new NoSuchElementException("No more tuples present");
        }
        if (parentPos.pos == parentPos.page.getNbElems() && ((parentPos = this.findNextParentPos()) == null || parentPos.page == null)) {
            throw new NoSuchElementException("No more tuples present");
        }
        Object value = null;
        if (parentPos.valueCursor.hasNext()) {
            if (parentPos.pos == -1) {
                ++parentPos.pos;
            }
            value = parentPos.valueCursor.next();
        } else {
            if (parentPos.pos == parentPos.page.getNbElems() - 1) {
                parentPos = this.findNextParentPos();
                if (parentPos == null || parentPos.page == null) {
                    throw new NoSuchElementException("No more tuples present");
                }
            } else {
                ++parentPos.pos;
            }
            try {
                ValueHolder valueHolder = ((AbstractPage)parentPos.page).getValue(parentPos.pos);
                parentPos.valueCursor = valueHolder.getCursor();
                value = parentPos.valueCursor.next();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        AbstractPage leaf = (AbstractPage)parentPos.page;
        this.tuple.setKey(leaf.getKey(parentPos.pos));
        this.tuple.setValue(value);
        return this.tuple;
    }

    public Tuple<K, V> nextKey() throws EndOfFileExceededException, IOException {
        if (this.stack == null || this.stack.length == 0) {
            throw new NoSuchElementException("No more tuples present");
        }
        ParentPos<K, V> parentPos = this.stack[this.depth];
        if (parentPos.page == null) {
            throw new NoSuchElementException("No more tuples present");
        }
        if (parentPos.pos == parentPos.page.getNbElems() - 1) {
            ParentPos<K, V> newParentPos = this.findNextParentPos();
            if (newParentPos == null || newParentPos.page == null) {
                AbstractPage leaf = (AbstractPage)parentPos.page;
                ValueHolder valueHolder = leaf.getValue(parentPos.pos);
                parentPos.pos = -2;
                parentPos.valueCursor = valueHolder.getCursor();
                parentPos.valueCursor.afterLast();
                return null;
            }
            parentPos = newParentPos;
        } else {
            ++parentPos.pos;
        }
        AbstractPage leaf = (AbstractPage)parentPos.page;
        this.tuple.setKey(leaf.getKey(parentPos.pos));
        ValueHolder valueHolder = leaf.getValue(parentPos.pos);
        parentPos.valueCursor = valueHolder.getCursor();
        Object value = parentPos.valueCursor.next();
        this.tuple.setValue(value);
        return this.tuple;
    }

    public boolean hasNextKey() throws EndOfFileExceededException, IOException {
        if (this.stack == null || this.stack.length == 0) {
            return false;
        }
        ParentPos<K, V> parentPos = this.stack[this.depth];
        if (parentPos.page == null) {
            return false;
        }
        if (parentPos.pos == parentPos.page.getNbElems() - 1) {
            return this.hasNextParentPos();
        }
        return true;
    }

    public boolean hasPrev() throws EndOfFileExceededException, IOException {
        if (this.stack == null || this.stack.length == 0) {
            return false;
        }
        ParentPos<K, V> parentPos = this.stack[this.depth];
        if (parentPos.page == null) {
            return false;
        }
        if (parentPos.pos > 0) {
            return true;
        }
        if (parentPos.pos == -1) {
            return false;
        }
        if (parentPos.valueCursor.hasPrev()) {
            return true;
        }
        for (int currentDepth = this.depth - 1; currentDepth >= 0; --currentDepth) {
            parentPos = this.stack[currentDepth];
            if (parentPos.pos <= 0) continue;
            return true;
        }
        return false;
    }

    public Tuple<K, V> prev() throws EndOfFileExceededException, IOException {
        if (this.stack == null || this.stack.length == 0) {
            throw new NoSuchElementException("No more tuple present");
        }
        ParentPos<K, V> parentPos = this.stack[this.depth];
        if (parentPos.page == null || parentPos.pos == -1) {
            throw new NoSuchElementException("No more tuples present");
        }
        if (!(parentPos.pos != 0 || parentPos.valueCursor.hasPrev() || (parentPos = this.findPrevParentPos()) != null && parentPos.page != null)) {
            throw new NoSuchElementException("No more tuples present");
        }
        Object value = null;
        if (parentPos.valueCursor.hasPrev()) {
            if (parentPos.pos == -2) {
                parentPos.pos = parentPos.page.getNbElems() - 1;
            }
            value = parentPos.valueCursor.prev();
        } else if (parentPos.pos == 0) {
            parentPos = this.findPrevParentPos();
            if (parentPos == null || parentPos.page == null) {
                throw new NoSuchElementException("No more tuples present");
            }
        } else {
            --parentPos.pos;
            try {
                ValueHolder valueHolder = ((AbstractPage)parentPos.page).getValue(parentPos.pos);
                parentPos.valueCursor = valueHolder.getCursor();
                parentPos.valueCursor.afterLast();
                value = parentPos.valueCursor.prev();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        AbstractPage leaf = (AbstractPage)parentPos.page;
        this.tuple.setKey(leaf.getKey(parentPos.pos));
        this.tuple.setValue(value);
        return this.tuple;
    }

    public Tuple<K, V> prevKey() throws EndOfFileExceededException, IOException {
        if (this.stack == null || this.stack.length == 0) {
            throw new NoSuchElementException("No more tuples present");
        }
        ParentPos<K, V> parentPos = this.stack[this.depth];
        if (parentPos.page == null) {
            throw new NoSuchElementException("No more tuples present");
        }
        if (parentPos.pos == 0) {
            parentPos = this.findPrevParentPos();
            if (parentPos == null || parentPos.page == null) {
                throw new NoSuchElementException("No more tuples present");
            }
        } else {
            parentPos.pos = parentPos.pos == -2 ? parentPos.page.getNbElems() - 1 : --parentPos.pos;
        }
        AbstractPage leaf = (AbstractPage)parentPos.page;
        this.tuple.setKey(leaf.getKey(parentPos.pos));
        ValueHolder valueHolder = leaf.getValue(parentPos.pos);
        parentPos.valueCursor = valueHolder.getCursor();
        Object value = parentPos.valueCursor.next();
        this.tuple.setValue(value);
        return this.tuple;
    }

    public boolean hasPrevKey() throws EndOfFileExceededException, IOException {
        if (this.stack == null || this.stack.length == 0) {
            return false;
        }
        ParentPos<K, V> parentPos = this.stack[this.depth];
        if (parentPos.page == null) {
            return false;
        }
        if (parentPos.pos == 0) {
            return this.hasPrevParentPos();
        }
        return true;
    }

    private boolean hasNextParentPos() throws EndOfFileExceededException, IOException {
        if (this.depth == 0) {
            return false;
        }
        Page child = null;
        for (int currentDepth = this.depth - 1; currentDepth >= 0; --currentDepth) {
            ParentPos<K, V> parentPos = this.stack[currentDepth];
            if (parentPos.pos + 1 > parentPos.page.getNbElems()) {
                continue;
            }
            child = ((AbstractPage)parentPos.page).getPage(parentPos.pos + 1);
            while (currentDepth < this.depth - 1) {
                ++currentDepth;
                child = ((AbstractPage)child).getPage(0);
            }
            return true;
        }
        return false;
    }

    private ParentPos<K, V> findNextParentPos() throws EndOfFileExceededException, IOException {
        if (this.depth == 0) {
            return null;
        }
        Page child = null;
        for (int currentDepth = this.depth - 1; currentDepth >= 0; --currentDepth) {
            ParentPos<K, V> parentPos = this.stack[currentDepth];
            if (parentPos.pos + 1 > parentPos.page.getNbElems()) {
                continue;
            }
            ++parentPos.pos;
            child = ((AbstractPage)parentPos.page).getPage(parentPos.pos);
            while (currentDepth < this.depth - 1) {
                parentPos = this.stack[++currentDepth];
                parentPos.pos = 0;
                parentPos.page = child;
                child = ((AbstractPage)child).getPage(0);
            }
            parentPos = this.stack[this.depth];
            parentPos.page = child;
            parentPos.pos = 0;
            parentPos.valueCursor = ((AbstractPage)child).getValue(0).getCursor();
            return parentPos;
        }
        return null;
    }

    private ParentPos<K, V> findPrevParentPos() throws EndOfFileExceededException, IOException {
        if (this.depth == 0) {
            return null;
        }
        Page child = null;
        for (int currentDepth = this.depth - 1; currentDepth >= 0; --currentDepth) {
            ParentPos<K, V> parentPos = this.stack[currentDepth];
            if (parentPos.pos == 0) {
                continue;
            }
            --parentPos.pos;
            child = ((AbstractPage)parentPos.page).getPage(parentPos.pos);
            while (currentDepth < this.depth - 1) {
                parentPos = this.stack[++currentDepth];
                parentPos.pos = child.getNbElems();
                parentPos.page = child;
                child = ((AbstractPage)parentPos.page).getPage(parentPos.page.getNbElems());
            }
            parentPos = this.stack[this.depth];
            parentPos.pos = child.getNbElems() - 1;
            parentPos.page = child;
            ValueHolder valueHolder = ((AbstractPage)parentPos.page).getValue(parentPos.pos);
            parentPos.valueCursor = valueHolder.getCursor();
            parentPos.valueCursor.afterLast();
            return parentPos;
        }
        return null;
    }

    private boolean hasPrevParentPos() throws EndOfFileExceededException, IOException {
        if (this.depth == 0) {
            return false;
        }
        Page child = null;
        for (int currentDepth = this.depth - 1; currentDepth >= 0; --currentDepth) {
            ParentPos<K, V> parentPos = this.stack[currentDepth];
            if (parentPos.pos == 0) {
                continue;
            }
            child = ((AbstractPage)parentPos.page).getPage(parentPos.pos - 1);
            while (currentDepth < this.depth - 1) {
                ++currentDepth;
                child = ((AbstractPage)child).getPage(child.getNbElems());
            }
            return true;
        }
        return false;
    }

    public void close() {
        this.transaction.close();
    }

    public long getCreationDate() {
        return this.transaction.getCreationDate();
    }

    public long getRevision() {
        return this.transaction.getRevision();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TupleCursor, depth = ").append(this.depth).append("\n");
        for (int i = 0; i <= this.depth; ++i) {
            sb.append("    ").append(this.stack[i]).append("\n");
        }
        return sb.toString();
    }
}

