/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.RecordManager;
import org.apache.directory.mavibot.btree.exception.BadTransactionStateException;

class WriteTransaction {
    private RecordManager recordManager;
    protected ReentrantLock writeLock;

    WriteTransaction(RecordManager recordManager) {
        System.out.println("Creating the transaction oject");
        this.recordManager = recordManager;
        this.writeLock = new ReentrantLock();
    }

    void start() {
        if (this.writeLock.isLocked()) {
            throw new BadTransactionStateException("Cannot start a write transaction when it's already started");
        }
        this.writeLock.lock();
    }

    void commit() {
        if (!this.writeLock.isLocked()) {
            throw new BadTransactionStateException("Cannot commit a write transaction when it's not started");
        }
        Map<Page<?, ?>, BTree<?, ?>> pendingPages = this.recordManager.getPendingPages();
        for (Page<?, ?> object : pendingPages.keySet()) {
            BTree<?, ?> btree = pendingPages.get(object);
            try {
                this.recordManager.writePage(btree, object, object.getRevision());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        pendingPages.clear();
        this.writeLock.unlock();
    }

    void rollback() {
        if (!this.writeLock.isLocked()) {
            throw new BadTransactionStateException("Cannot commit a write transaction when it's not started");
        }
        this.writeLock.unlock();
    }

    boolean isStarted() {
        return this.writeLock.isLocked();
    }
}

