/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.lang.reflect.Array;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.DeleteResult;
import org.apache.directory.mavibot.btree.KeyCursor;
import org.apache.directory.mavibot.btree.KeyHolder;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.PageHolder;
import org.apache.directory.mavibot.btree.ParentPos;
import org.apache.directory.mavibot.btree.ReadTransaction;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.TupleCursor;
import org.apache.directory.mavibot.btree.ValueCursor;
import org.apache.directory.mavibot.btree.ValueHolder;
import org.apache.directory.mavibot.btree.exception.EndOfFileExceededException;
import org.apache.directory.mavibot.btree.exception.KeyNotFoundException;

abstract class AbstractPage<K, V>
implements Page<K, V> {
    protected transient BTree<K, V> btree;
    protected KeyHolder<K>[] keys;
    protected PageHolder<K, V>[] children;
    protected int nbElems;
    protected long revision;
    protected long offset = -1L;
    protected long lastOffset = -1L;

    protected AbstractPage(BTree<K, V> btree) {
        this.btree = btree;
    }

    protected AbstractPage(BTree<K, V> btree, long revision, int nbElems) {
        this.btree = btree;
        this.revision = revision;
        this.nbElems = nbElems;
        this.keys = (KeyHolder[])Array.newInstance(KeyHolder.class, nbElems);
    }

    @Override
    public int getNbElems() {
        return this.nbElems;
    }

    void setNbElems(int nbElems) {
        this.nbElems = nbElems;
    }

    @Override
    public K getKey(int pos) {
        if (pos < this.nbElems && this.keys[pos] != null) {
            return this.keys[pos].getKey();
        }
        return null;
    }

    @Override
    public boolean hasKey(K key) throws IOException {
        int pos = this.findPos(key);
        if (pos < 0) {
            return this.children[-pos].getValue().hasKey(key);
        }
        Page<K, V> page = this.children[pos].getValue();
        if (page == null) {
            System.out.println("Page is null for pos = " + pos + ", children = " + this.children[pos]);
        }
        return page.hasKey(key);
    }

    Page<K, V> getReference(int pos) throws IOException {
        if (pos < this.nbElems + 1) {
            if (this.children[pos] != null) {
                return this.children[pos].getValue();
            }
            return null;
        }
        return null;
    }

    @Override
    public TupleCursor<K, V> browse(K key, ReadTransaction<K, V> transaction, ParentPos<K, V>[] stack, int depth) throws IOException {
        int pos = this.findPos(key);
        if (pos < 0) {
            pos = -pos;
        }
        stack[depth++] = new ParentPos(this, pos);
        Page<K, V> page = this.children[pos].getValue();
        return page.browse(key, transaction, stack, depth);
    }

    @Override
    public boolean contains(K key, V value) throws IOException {
        int pos = this.findPos(key);
        if (pos < 0) {
            return this.children[-pos].getValue().contains(key, value);
        }
        return this.children[pos].getValue().contains(key, value);
    }

    @Override
    public DeleteResult<K, V> delete(K key, V value, long revision) throws IOException {
        return this.delete(key, value, revision, null, -1);
    }

    abstract DeleteResult<K, V> delete(K var1, V var2, long var3, Page<K, V> var5, int var6) throws IOException;

    @Override
    public V get(K key) throws IOException, KeyNotFoundException {
        int pos = this.findPos(key);
        if (pos < 0) {
            return this.children[-pos].getValue().get(key);
        }
        return this.children[pos].getValue().get(key);
    }

    Page<K, V> getPage(int pos) {
        if (pos >= 0 && pos < this.children.length) {
            if (this.children[pos] != null) {
                return this.children[pos].getValue();
            }
            return null;
        }
        return null;
    }

    void setPageHolder(int pos, PageHolder<K, V> pageHolder) {
        if (pos >= 0 && pos < this.children.length) {
            this.children[pos] = pageHolder;
        }
    }

    @Override
    public ValueCursor<V> getValues(K key) throws KeyNotFoundException, IOException, IllegalArgumentException {
        int pos = this.findPos(key);
        if (pos < 0) {
            return this.children[-pos].getValue().getValues(key);
        }
        return this.children[pos].getValue().getValues(key);
    }

    @Override
    public TupleCursor<K, V> browse(ReadTransaction<K, V> transaction, ParentPos<K, V>[] stack, int depth) throws IOException {
        stack[depth++] = new ParentPos(this, 0);
        Page<K, V> page = this.children[0].getValue();
        return page.browse(transaction, stack, depth);
    }

    @Override
    public KeyCursor<K> browseKeys(ReadTransaction<K, K> transaction, ParentPos<K, K>[] stack, int depth) throws IOException {
        stack[depth++] = new ParentPos(this, 0);
        Page<K, V> page = this.children[0].getValue();
        return page.browseKeys(transaction, stack, depth);
    }

    protected int selectSibling(Page<K, V> parent, int parentPos) throws IOException {
        int nextPageSize;
        if (parentPos == 0) {
            return 1;
        }
        if (parentPos == parent.getNbElems()) {
            return parentPos - 1;
        }
        Page<K, V> prevPage = ((AbstractPage)parent).getPage(parentPos - 1);
        Page<K, V> nextPage = ((AbstractPage)parent).getPage(parentPos + 1);
        int prevPageSize = prevPage.getNbElems();
        if (prevPageSize >= (nextPageSize = nextPage.getNbElems())) {
            return parentPos - 1;
        }
        return parentPos + 1;
    }

    @Override
    public K getLeftMostKey() {
        return this.keys[0].getKey();
    }

    @Override
    public K getRightMostKey() {
        return this.keys[this.nbElems - 1].getKey();
    }

    long getOffset() {
        return this.offset;
    }

    void setOffset(long offset) {
        this.offset = offset;
    }

    long getLastOffset() {
        return this.lastOffset;
    }

    void setLastOffset(long lastOffset) {
        this.lastOffset = lastOffset;
    }

    KeyHolder<K>[] getKeys() {
        return this.keys;
    }

    void setKey(int pos, KeyHolder<K> key) {
        this.keys[pos] = key;
    }

    void setKeys(KeyHolder<K>[] keys) {
        this.keys = keys;
    }

    ValueHolder<V> getValue(int pos) {
        return null;
    }

    @Override
    public long getRevision() {
        return this.revision;
    }

    void setRevision(long revision) {
        this.revision = revision;
    }

    protected final int compare(K key1, K key2) {
        if (key1 == key2) {
            return 0;
        }
        if (key1 == null) {
            return 1;
        }
        if (key2 == null) {
            return -1;
        }
        return this.btree.getKeyComparator().compare(key1, key2);
    }

    @Override
    public int findPos(K key) {
        if (this.nbElems == 0) {
            return 0;
        }
        int min = 0;
        int max = this.nbElems - 1;
        while (min < max) {
            int middle = min + max + 1 >> 1;
            int comp = this.compare(this.keys[middle].getKey(), key);
            if (comp < 0) {
                min = middle + 1;
                continue;
            }
            if (comp > 0) {
                max = middle - 1;
                continue;
            }
            return -(middle + 1);
        }
        int comp = this.compare(this.keys[max].getKey(), key);
        if (comp == 0) {
            return -(max + 1);
        }
        if (comp < 0) {
            return max + 1;
        }
        return max;
    }

    @Override
    public Tuple<K, V> findLeftMost() throws EndOfFileExceededException, IOException {
        return this.children[0].getValue().findLeftMost();
    }

    @Override
    public Tuple<K, V> findRightMost() throws EndOfFileExceededException, IOException {
        return this.children[this.nbElems].getValue().findRightMost();
    }

    public BTree<K, V> getBtree() {
        return this.btree;
    }

    @Override
    public String dumpPage(String tabs) {
        StringBuilder sb = new StringBuilder();
        if (this.nbElems > 0) {
            sb.append(this.children[0].getValue().dumpPage(tabs + "    "));
            for (int i = 0; i < this.nbElems; ++i) {
                sb.append(tabs);
                sb.append("<");
                sb.append(this.getKey(i)).append(">\n");
                sb.append(this.children[i + 1].getValue().dumpPage(tabs + "    "));
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("r").append(this.revision);
        sb.append(", nbElems:").append(this.nbElems);
        if (this.offset > 0L) {
            sb.append(", offset:").append(this.offset);
        }
        return sb.toString();
    }
}

