/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.util.Iterator;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.ClosureMonitor;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.CursorIterator;
import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexCursorAdaptor<K>
extends AbstractIndexCursor<K> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger(Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    final Cursor<Tuple> wrappedCursor;
    final IndexEntry<K, String> forwardEntry;

    public IndexCursorAdaptor(Cursor<Tuple> wrappedCursor, boolean forwardIndex) {
        this.wrappedCursor = wrappedCursor;
        this.forwardEntry = new IndexEntry();
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating IndexCursorAdaptor {}", (Object)this);
        }
    }

    @Override
    public boolean available() {
        return this.wrappedCursor.available();
    }

    @Override
    public void before(IndexEntry<K, String> element) throws LdapException, CursorException {
        this.wrappedCursor.before(element.getTuple());
    }

    @Override
    public void after(IndexEntry<K, String> element) throws LdapException, CursorException {
        this.wrappedCursor.after(element.getTuple());
    }

    @Override
    public void beforeFirst() throws LdapException, CursorException {
        this.wrappedCursor.beforeFirst();
    }

    @Override
    public void afterLast() throws LdapException, CursorException {
        this.wrappedCursor.afterLast();
    }

    @Override
    public boolean first() throws LdapException, CursorException {
        return this.wrappedCursor.first();
    }

    @Override
    public boolean last() throws LdapException, CursorException {
        return this.wrappedCursor.last();
    }

    @Override
    public boolean isClosed() {
        return this.wrappedCursor.isClosed();
    }

    @Override
    public boolean previous() throws LdapException, CursorException {
        return this.wrappedCursor.previous();
    }

    @Override
    public boolean next() throws LdapException, CursorException {
        return this.wrappedCursor.next();
    }

    @Override
    public IndexEntry<K, String> get() throws CursorException {
        Tuple tuple = this.wrappedCursor.get();
        this.forwardEntry.setTuple(tuple);
        return this.forwardEntry;
    }

    @Override
    public final void setClosureMonitor(ClosureMonitor monitor) {
        this.wrappedCursor.setClosureMonitor(monitor);
    }

    @Override
    public void close() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing IndexCursorAdaptor {}", (Object)this);
        }
        this.wrappedCursor.close();
    }

    @Override
    public void close(Exception reason) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing IndexCursorAdaptor {}", (Object)this);
        }
        this.wrappedCursor.close(reason);
    }

    @Override
    public Iterator<IndexEntry<K, String>> iterator() {
        return new CursorIterator<IndexEntry<K, String>>(this);
    }

    @Override
    public boolean isAfterLast() {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("isAfterLast()")));
    }

    @Override
    public boolean isBeforeFirst() {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("isBeforeFirst()")));
    }

    @Override
    public boolean isFirst() {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("isFirst()")));
    }

    @Override
    public boolean isLast() {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("isLast()")));
    }

    @Override
    protected String getUnsupportedMessage() {
        return "Unsupported operation";
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("IndexCursorAdaptor (");
        if (this.available()) {
            sb.append("available)");
        } else {
            sb.append("absent)");
        }
        sb.append(" :\n");
        sb.append(this.wrappedCursor.toString(tabs + "    "));
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

