/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.avltree;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Comparator;
import org.apache.directory.server.core.avltree.AvlTree;
import org.apache.directory.server.core.avltree.AvlTreeImpl;
import org.apache.directory.server.core.avltree.DefaultMarshaller;
import org.apache.directory.server.core.avltree.LinkedAvlNode;
import org.apache.directory.server.core.avltree.Marshaller;
import org.apache.directory.server.i18n.I18n;

public class AvlTreeMarshaller<E>
implements Marshaller<AvlTree<E>> {
    private static final byte[] EMPTY_TREE = new byte[1];
    private Marshaller<E> keyMarshaller;
    private Comparator<E> comparator;

    public AvlTreeMarshaller(Comparator<E> comparator, Marshaller<E> keyMarshaller) {
        this.comparator = comparator;
        this.keyMarshaller = keyMarshaller;
    }

    public AvlTreeMarshaller(Comparator<E> comparator) {
        this.comparator = comparator;
        this.keyMarshaller = DefaultMarshaller.INSTANCE;
    }

    @Override
    public byte[] serialize(AvlTree<E> tree) {
        if (tree.isEmpty()) {
            return EMPTY_TREE;
        }
        LinkedAvlNode x = tree.getFirst().next;
        while (x != null) {
            x.setIndex(x.previous.getIndex() + 1);
            x = x.next;
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        byte[] data = null;
        try {
            out.writeByte(0);
            out.writeInt(tree.getSize());
            this.writeTree(tree.getRoot(), out);
            out.flush();
            data = byteStream.toByteArray();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return data;
    }

    private void writeTree(LinkedAvlNode<E> node, DataOutputStream out) throws IOException {
        byte[] data = this.keyMarshaller.serialize(node.getKey());
        out.writeInt(data.length);
        out.write(data);
        out.writeInt(node.getIndex());
        if (node.getLeft() != null) {
            out.writeInt(2);
            this.writeTree(node.getLeft(), out);
        } else {
            out.writeInt(0);
        }
        if (node.getRight() != null) {
            out.writeInt(4);
            this.writeTree(node.getRight(), out);
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public AvlTree<E> deserialize(byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            throw new IOException(I18n.err(I18n.ERR_439, new Object[0]));
        }
        if (data.length == 1 && data[0] == 0) {
            return new AvlTreeImpl<E>(this.comparator);
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        DataInputStream din = new DataInputStream(bin);
        byte startByte = din.readByte();
        if (startByte != 0) {
            throw new IOException(I18n.err(I18n.ERR_443, new Object[0]));
        }
        int size = din.readInt();
        LinkedAvlNode[] nodes = new LinkedAvlNode[size];
        LinkedAvlNode<E> root = this.readTree(din, null, nodes);
        AvlTreeImpl<E> tree = new AvlTreeImpl<E>(this.comparator);
        tree.setRoot(root);
        tree.setFirst(nodes[0]);
        tree.setSize(size);
        if (nodes.length >= 1) {
            tree.setLast(nodes[nodes.length - 1]);
        }
        for (int i = 0; i < nodes.length - 1; ++i) {
            nodes[i].setNext(nodes[i + 1]);
            nodes[i + 1].setPrevious(nodes[i]);
        }
        return tree;
    }

    public LinkedAvlNode<E> readTree(DataInputStream in, LinkedAvlNode<E> node, LinkedAvlNode[] nodes) throws IOException {
        int dLen = in.readInt();
        byte[] data = new byte[dLen];
        in.read(data);
        E key = this.keyMarshaller.deserialize(data);
        node = new LinkedAvlNode<E>(key);
        int index = in.readInt();
        nodes[index] = node;
        int childMarker = in.readInt();
        if (childMarker == 2) {
            node.setLeft(this.readTree(in, node.getLeft(), nodes));
        }
        if ((childMarker = in.readInt()) == 4) {
            node.setRight(this.readTree(in, node.getRight(), nodes));
        }
        return node;
    }
}

