/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.util.Iterator;
import org.apache.directory.server.xdbm.ForwardIndexEntry;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.ReverseIndexEntry;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.cursor.ClosureMonitor;
import org.apache.directory.shared.ldap.model.cursor.Cursor;
import org.apache.directory.shared.ldap.model.cursor.CursorIterator;
import org.apache.directory.shared.ldap.model.cursor.Tuple;
import org.apache.directory.shared.ldap.model.cursor.TupleCursor;

public class IndexCursorAdaptor<K, O, ID>
implements IndexCursor<K, O, ID> {
    final Cursor<Tuple> wrappedCursor;
    final ForwardIndexEntry<K, O, ID> forwardEntry;
    final ReverseIndexEntry<K, O, ID> reverseEntry;

    public IndexCursorAdaptor(Cursor<Tuple> wrappedCursor, boolean forwardIndex) {
        this.wrappedCursor = wrappedCursor;
        if (forwardIndex) {
            this.forwardEntry = new ForwardIndexEntry();
            this.reverseEntry = null;
        } else {
            this.forwardEntry = null;
            this.reverseEntry = new ReverseIndexEntry();
        }
    }

    @Override
    public boolean available() {
        return this.wrappedCursor.available();
    }

    @Override
    public void beforeValue(ID id, K key) throws Exception {
        if (this.wrappedCursor instanceof TupleCursor) {
            ((TupleCursor)this.wrappedCursor).beforeValue(key, id);
        }
    }

    @Override
    public void afterValue(ID id, K key) throws Exception {
        if (this.wrappedCursor instanceof TupleCursor) {
            ((TupleCursor)this.wrappedCursor).afterValue(key, id);
        }
    }

    @Override
    public void before(IndexEntry<K, O, ID> element) throws Exception {
        this.wrappedCursor.before(element.getTuple());
    }

    @Override
    public void after(IndexEntry<K, O, ID> element) throws Exception {
        this.wrappedCursor.after(element.getTuple());
    }

    @Override
    public void beforeFirst() throws Exception {
        this.wrappedCursor.beforeFirst();
    }

    @Override
    public void afterLast() throws Exception {
        this.wrappedCursor.afterLast();
    }

    @Override
    public boolean first() throws Exception {
        return this.wrappedCursor.first();
    }

    @Override
    public boolean last() throws Exception {
        return this.wrappedCursor.last();
    }

    @Override
    public boolean isClosed() throws Exception {
        return this.wrappedCursor.isClosed();
    }

    @Override
    public boolean previous() throws Exception {
        return this.wrappedCursor.previous();
    }

    @Override
    public boolean next() throws Exception {
        return this.wrappedCursor.next();
    }

    @Override
    public IndexEntry<K, O, ID> get() throws Exception {
        if (this.forwardEntry != null) {
            Tuple tuple = this.wrappedCursor.get();
            this.forwardEntry.setTuple(tuple, null);
            return this.forwardEntry;
        }
        Tuple tuple = this.wrappedCursor.get();
        this.reverseEntry.setTuple(tuple, null);
        return this.reverseEntry;
    }

    @Override
    public final void setClosureMonitor(ClosureMonitor monitor) {
        this.wrappedCursor.setClosureMonitor(monitor);
    }

    @Override
    public void close() throws Exception {
        this.wrappedCursor.close();
    }

    @Override
    public void close(Exception reason) throws Exception {
        this.wrappedCursor.close(reason);
    }

    @Override
    public Iterator<IndexEntry<K, O, ID>> iterator() {
        return new CursorIterator<IndexEntry<K, O, ID>>(this);
    }

    @Override
    public boolean isAfterLast() throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("isAfterLast()")));
    }

    @Override
    public boolean isBeforeFirst() throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("isBeforeFirst()")));
    }

    @Override
    public boolean isFirst() throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("isFirst()")));
    }

    @Override
    public boolean isLast() throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("isLast()")));
    }
}

