/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.directory.server.core.DnFactory;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.schema.DescriptionParsers;
import org.apache.directory.server.core.schema.SchemaSubentryModifier;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.DITContentRule;
import org.apache.directory.shared.ldap.model.schema.DITStructureRule;
import org.apache.directory.shared.ldap.model.schema.LdapSyntax;
import org.apache.directory.shared.ldap.model.schema.MatchingRule;
import org.apache.directory.shared.ldap.model.schema.MatchingRuleUse;
import org.apache.directory.shared.ldap.model.schema.NameForm;
import org.apache.directory.shared.ldap.model.schema.ObjectClass;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.parsers.LdapComparatorDescription;
import org.apache.directory.shared.ldap.model.schema.parsers.NormalizerDescription;
import org.apache.directory.shared.ldap.model.schema.parsers.SyntaxCheckerDescription;
import org.apache.directory.shared.ldap.model.schema.registries.SchemaLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaSubentryManager {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaSubentryManager.class);
    private static final int COMPARATOR_INDEX = 0;
    private static final int NORMALIZER_INDEX = 1;
    private static final int SYNTAX_CHECKER_INDEX = 2;
    private static final int SYNTAX_INDEX = 3;
    private static final int MATCHING_RULE_INDEX = 4;
    private static final int ATTRIBUTE_TYPE_INDEX = 5;
    private static final int OBJECT_CLASS_INDEX = 6;
    private static final int MATCHING_RULE_USE_INDEX = 7;
    private static final int DIT_STRUCTURE_RULE_INDEX = 8;
    private static final int DIT_CONTENT_RULE_INDEX = 9;
    private static final int NAME_FORM_INDEX = 10;
    private static final Set<String> VALID_OU_VALUES = new HashSet<String>();
    private final SchemaManager schemaManager;
    private final SchemaSubentryModifier subentryModifier;
    private final DescriptionParsers parsers;
    private final Map<String, Integer> opAttr2handlerIndex = new HashMap<String, Integer>(11);
    private static final String CASCADING_ERROR = "Cascading has not yet been implemented: standard operation is in effect.";
    private static AttributeType ENTRY_CSN_ATTRIBUTE_TYPE;

    public SchemaSubentryManager(SchemaManager schemaManager, SchemaLoader loader, DnFactory dnFactory) throws LdapException {
        this.schemaManager = schemaManager;
        this.subentryModifier = new SchemaSubentryModifier(schemaManager, dnFactory);
        this.parsers = new DescriptionParsers(schemaManager);
        String comparatorsOid = schemaManager.getAttributeTypeRegistry().getOidByName("comparators");
        this.opAttr2handlerIndex.put(comparatorsOid, 0);
        String normalizersOid = schemaManager.getAttributeTypeRegistry().getOidByName("normalizers");
        this.opAttr2handlerIndex.put(normalizersOid, 1);
        String syntaxCheckersOid = schemaManager.getAttributeTypeRegistry().getOidByName("syntaxCheckers");
        this.opAttr2handlerIndex.put(syntaxCheckersOid, 2);
        String ldapSyntaxesOid = schemaManager.getAttributeTypeRegistry().getOidByName("ldapSyntaxes");
        this.opAttr2handlerIndex.put(ldapSyntaxesOid, 3);
        String matchingRulesOid = schemaManager.getAttributeTypeRegistry().getOidByName("matchingRules");
        this.opAttr2handlerIndex.put(matchingRulesOid, 4);
        String attributeTypesOid = schemaManager.getAttributeTypeRegistry().getOidByName("attributeTypes");
        this.opAttr2handlerIndex.put(attributeTypesOid, 5);
        String objectClassesOid = schemaManager.getAttributeTypeRegistry().getOidByName("objectClasses");
        this.opAttr2handlerIndex.put(objectClassesOid, 6);
        String matchingRuleUseOid = schemaManager.getAttributeTypeRegistry().getOidByName("matchingRuleUse");
        this.opAttr2handlerIndex.put(matchingRuleUseOid, 7);
        String ditStructureRulesOid = schemaManager.getAttributeTypeRegistry().getOidByName("ditStructureRules");
        this.opAttr2handlerIndex.put(ditStructureRulesOid, 8);
        String ditContentRulesOid = schemaManager.getAttributeTypeRegistry().getOidByName("ditContentRules");
        this.opAttr2handlerIndex.put(ditContentRulesOid, 9);
        String nameFormsOid = schemaManager.getAttributeTypeRegistry().getOidByName("nameForms");
        this.opAttr2handlerIndex.put(nameFormsOid, 10);
        ENTRY_CSN_ATTRIBUTE_TYPE = schemaManager.getAttributeType("entryCSN");
    }

    public void modifySchemaSubentry(ModifyOperationContext modifyContext, boolean doCascadeModify) throws LdapException {
        for (Modification mod : modifyContext.getModItems()) {
            String opAttrOid = this.schemaManager.getAttributeTypeRegistry().getOidByName(mod.getAttribute().getId());
            Attribute serverAttribute = mod.getAttribute();
            switch (mod.getOperation()) {
                case ADD_ATTRIBUTE: {
                    this.modifyAddOperation(modifyContext, opAttrOid, serverAttribute, doCascadeModify);
                    break;
                }
                case REMOVE_ATTRIBUTE: {
                    this.modifyRemoveOperation(modifyContext, opAttrOid, serverAttribute);
                    break;
                }
                case REPLACE_ATTRIBUTE: {
                    if (ENTRY_CSN_ATTRIBUTE_TYPE.equals(serverAttribute.getAttributeType())) break;
                    throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_283, new Object[0]));
                }
                default: {
                    throw new IllegalStateException(I18n.err(I18n.ERR_284, new Object[]{mod.getOperation()}));
                }
            }
        }
    }

    private void modifyRemoveOperation(ModifyOperationContext modifyContext, String opAttrOid, Attribute mods) throws LdapException {
        int index = this.opAttr2handlerIndex.get(opAttrOid);
        switch (index) {
            case 0: {
                LdapComparatorDescription[] comparatorDescriptions;
                for (LdapComparatorDescription comparatorDescription : comparatorDescriptions = this.parsers.parseComparators(mods)) {
                    this.subentryModifier.delete((OperationContext)modifyContext, comparatorDescription);
                }
                break;
            }
            case 1: {
                NormalizerDescription[] normalizerDescriptions;
                for (NormalizerDescription normalizerDescription : normalizerDescriptions = this.parsers.parseNormalizers(mods)) {
                    this.subentryModifier.delete((OperationContext)modifyContext, normalizerDescription);
                }
                break;
            }
            case 2: {
                SyntaxCheckerDescription[] syntaxCheckerDescriptions;
                for (SyntaxCheckerDescription syntaxCheckerDescription : syntaxCheckerDescriptions = this.parsers.parseSyntaxCheckers(mods)) {
                    this.subentryModifier.delete((OperationContext)modifyContext, syntaxCheckerDescription);
                }
                break;
            }
            case 3: {
                LdapSyntax[] syntaxes;
                for (LdapSyntax syntax : syntaxes = this.parsers.parseLdapSyntaxes(mods)) {
                    this.subentryModifier.deleteSchemaObject(modifyContext, syntax);
                }
                break;
            }
            case 4: {
                MatchingRule[] mrs;
                for (MatchingRule mr : mrs = this.parsers.parseMatchingRules(mods)) {
                    this.subentryModifier.deleteSchemaObject(modifyContext, mr);
                }
                break;
            }
            case 5: {
                AttributeType[] ats;
                for (AttributeType at : ats = this.parsers.parseAttributeTypes(mods)) {
                    this.subentryModifier.deleteSchemaObject(modifyContext, at);
                }
                break;
            }
            case 6: {
                ObjectClass[] ocs;
                for (ObjectClass oc : ocs = this.parsers.parseObjectClasses(mods)) {
                    this.subentryModifier.deleteSchemaObject(modifyContext, oc);
                }
                break;
            }
            case 7: {
                MatchingRuleUse[] mrus;
                for (MatchingRuleUse mru : mrus = this.parsers.parseMatchingRuleUses(mods)) {
                    this.subentryModifier.deleteSchemaObject(modifyContext, mru);
                }
                break;
            }
            case 8: {
                DITStructureRule[] dsrs;
                for (DITStructureRule dsr : dsrs = this.parsers.parseDitStructureRules(mods)) {
                    this.subentryModifier.deleteSchemaObject(modifyContext, dsr);
                }
                break;
            }
            case 9: {
                DITContentRule[] dcrs;
                for (DITContentRule dcr : dcrs = this.parsers.parseDitContentRules(mods)) {
                    this.subentryModifier.deleteSchemaObject(modifyContext, dcr);
                }
                break;
            }
            case 10: {
                NameForm[] nfs;
                for (NameForm nf : nfs = this.parsers.parseNameForms(mods)) {
                    this.subentryModifier.deleteSchemaObject(modifyContext, nf);
                }
                break;
            }
            default: {
                throw new IllegalStateException(I18n.err(I18n.ERR_285, index));
            }
        }
    }

    private void modifyAddOperation(ModifyOperationContext modifyContext, String opAttrOid, Attribute mods, boolean doCascadeModify) throws LdapException {
        if (doCascadeModify) {
            LOG.error(CASCADING_ERROR);
        }
        int index = this.opAttr2handlerIndex.get(opAttrOid);
        switch (index) {
            case 0: {
                LdapComparatorDescription[] comparatorDescriptions;
                for (LdapComparatorDescription comparatorDescription : comparatorDescriptions = this.parsers.parseComparators(mods)) {
                    this.subentryModifier.add((OperationContext)modifyContext, comparatorDescription);
                }
                break;
            }
            case 1: {
                NormalizerDescription[] normalizerDescriptions;
                for (NormalizerDescription normalizerDescription : normalizerDescriptions = this.parsers.parseNormalizers(mods)) {
                    this.subentryModifier.add((OperationContext)modifyContext, normalizerDescription);
                }
                break;
            }
            case 2: {
                SyntaxCheckerDescription[] syntaxCheckerDescriptions;
                for (SyntaxCheckerDescription syntaxCheckerDescription : syntaxCheckerDescriptions = this.parsers.parseSyntaxCheckers(mods)) {
                    this.subentryModifier.add((OperationContext)modifyContext, syntaxCheckerDescription);
                }
                break;
            }
            case 3: {
                LdapSyntax[] syntaxes;
                for (LdapSyntax syntax : syntaxes = this.parsers.parseLdapSyntaxes(mods)) {
                    this.subentryModifier.addSchemaObject(modifyContext, syntax);
                }
                break;
            }
            case 4: {
                MatchingRule[] mrs;
                for (MatchingRule mr : mrs = this.parsers.parseMatchingRules(mods)) {
                    this.subentryModifier.addSchemaObject(modifyContext, mr);
                }
                break;
            }
            case 5: {
                AttributeType[] ats;
                for (AttributeType at : ats = this.parsers.parseAttributeTypes(mods)) {
                    this.subentryModifier.addSchemaObject(modifyContext, at);
                }
                break;
            }
            case 6: {
                ObjectClass[] ocs;
                for (ObjectClass oc : ocs = this.parsers.parseObjectClasses(mods)) {
                    this.subentryModifier.addSchemaObject(modifyContext, oc);
                }
                break;
            }
            case 7: {
                MatchingRuleUse[] mrus;
                for (MatchingRuleUse mru : mrus = this.parsers.parseMatchingRuleUses(mods)) {
                    this.subentryModifier.addSchemaObject(modifyContext, mru);
                }
                break;
            }
            case 8: {
                DITStructureRule[] dsrs;
                for (DITStructureRule dsr : dsrs = this.parsers.parseDitStructureRules(mods)) {
                    this.subentryModifier.addSchemaObject(modifyContext, dsr);
                }
                break;
            }
            case 9: {
                DITContentRule[] dcrs;
                for (DITContentRule dcr : dcrs = this.parsers.parseDitContentRules(mods)) {
                    this.subentryModifier.addSchemaObject(modifyContext, dcr);
                }
                break;
            }
            case 10: {
                NameForm[] nfs;
                for (NameForm nf : nfs = this.parsers.parseNameForms(mods)) {
                    this.subentryModifier.addSchemaObject(modifyContext, nf);
                }
                break;
            }
            default: {
                throw new IllegalStateException(I18n.err(I18n.ERR_285, index));
            }
        }
    }

    static {
        VALID_OU_VALUES.add("normalizers".toLowerCase());
        VALID_OU_VALUES.add("comparators".toLowerCase());
        VALID_OU_VALUES.add("syntaxCheckers".toLowerCase());
        VALID_OU_VALUES.add("syntaxes".toLowerCase());
        VALID_OU_VALUES.add("matchingRules".toLowerCase());
        VALID_OU_VALUES.add("matchingRuleUse".toLowerCase());
        VALID_OU_VALUES.add("attributeTypes".toLowerCase());
        VALID_OU_VALUES.add("objectClasses".toLowerCase());
        VALID_OU_VALUES.add("nameForms".toLowerCase());
        VALID_OU_VALUES.add("ditContentRules".toLowerCase());
        VALID_OU_VALUES.add("ditStructureRules".toLowerCase());
    }
}

