/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication;

import java.util.Iterator;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmTable;
import org.apache.directory.server.ldap.replication.ReplicaEventMessage;
import org.apache.directory.shared.ldap.model.cursor.AbstractCursor;
import org.apache.directory.shared.ldap.model.cursor.Cursor;
import org.apache.directory.shared.ldap.model.cursor.Tuple;
import org.apache.directory.shared.ldap.model.message.controls.ChangeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaJournalCursor
extends AbstractCursor<ReplicaEventMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicaJournalCursor.class);
    private Cursor<Tuple<String, ReplicaEventMessage>> tupleCursor;
    private JdbmTable<String, ReplicaEventMessage> journal;
    private String consumerCsn;
    private ReplicaEventMessage qualifiedEvtMsg;

    public ReplicaJournalCursor(JdbmTable<String, ReplicaEventMessage> journal, String consumerCsn) throws Exception {
        this.journal = journal;
        this.tupleCursor = journal.cursor();
        this.consumerCsn = consumerCsn;
    }

    @Override
    public void after(ReplicaEventMessage arg0) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void afterLast() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean available() {
        return this.qualifiedEvtMsg != null;
    }

    @Override
    public void before(ReplicaEventMessage arg0) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void beforeFirst() throws Exception {
    }

    @Override
    public boolean first() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public ReplicaEventMessage get() throws Exception {
        return this.qualifiedEvtMsg;
    }

    private void selectQualified() throws Exception {
        Tuple<String, ReplicaEventMessage> t = this.tupleCursor.get();
        this.qualifiedEvtMsg = t.getValue();
        LOG.debug("ReplicaEventMessage: {}", this.qualifiedEvtMsg);
        if (this.qualifiedEvtMsg.isEventOlderThan(this.consumerCsn)) {
            if (LOG.isDebugEnabled()) {
                String evt = "MODDN";
                ChangeType changeType = this.qualifiedEvtMsg.getChangeType();
                if (changeType != null) {
                    evt = changeType.name();
                }
                LOG.debug("event {} for dn {} is not qualified for sending", (Object)evt, (Object)this.qualifiedEvtMsg.getEntry().getDn());
            }
            this.journal.remove(t.getKey());
            this.qualifiedEvtMsg = null;
        }
    }

    @Override
    public boolean last() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean next() throws Exception {
        while (this.tupleCursor.next()) {
            this.selectQualified();
            if (this.qualifiedEvtMsg == null) continue;
            return true;
        }
        this.qualifiedEvtMsg = null;
        return false;
    }

    @Override
    public boolean previous() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws Exception {
        this.tupleCursor.close();
        super.close();
    }

    @Override
    public void close(Exception cause) throws Exception {
        this.tupleCursor.close();
        super.close(cause);
    }

    @Override
    public Iterator<ReplicaEventMessage> iterator() {
        throw new UnsupportedOperationException();
    }
}

