/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.ForwardIndexEntry;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.impl.GreaterEqEvaluator;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.schema.AttributeType;

public class GreaterEqCursor<V, ID extends Comparable<ID>>
extends AbstractIndexCursor<V, Entry, ID> {
    private static final String UNSUPPORTED_MSG = "GreaterEqCursors only support positioning by element when a user index exists on the asserted attribute.";
    private final GreaterEqEvaluator<V, ID> greaterEqEvaluator;
    private final IndexCursor<V, Entry, ID> userIdxCursor;
    private final IndexCursor<String, Entry, ID> ndnIdxCursor;
    IndexEntry<String, Entry, ID> ndnCandidate;
    private boolean available = false;

    public GreaterEqCursor(Store<Entry, ID> db, GreaterEqEvaluator greaterEqEvaluator) throws Exception {
        this.greaterEqEvaluator = greaterEqEvaluator;
        AttributeType attributeType = greaterEqEvaluator.getExpression().getAttributeType();
        if (db.hasIndexOn(attributeType)) {
            this.userIdxCursor = db.getIndex(attributeType).forwardCursor();
            this.ndnIdxCursor = null;
        } else {
            this.ndnIdxCursor = db.getEntryUuidIndex().forwardCursor();
            this.userIdxCursor = null;
        }
    }

    @Override
    public boolean available() {
        return this.available;
    }

    @Override
    public void beforeValue(ID id, V value) throws Exception {
        this.checkNotClosed("beforeValue()");
        if (this.userIdxCursor != null) {
            if (this.greaterEqEvaluator.getComparator().compare(value, this.greaterEqEvaluator.getExpression().getValue().getValue()) <= 0) {
                this.beforeFirst();
                return;
            }
        } else {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        this.userIdxCursor.beforeValue(id, value);
        this.available = false;
    }

    @Override
    public void afterValue(ID id, V value) throws Exception {
        this.checkNotClosed("afterValue()");
        if (this.userIdxCursor != null) {
            int comparedValue = this.greaterEqEvaluator.getComparator().compare(value, this.greaterEqEvaluator.getExpression().getValue().getValue());
            if (comparedValue == 0) {
                this.userIdxCursor.afterValue(id, value);
                this.available = false;
                return;
            }
            if (comparedValue < 0) {
                this.beforeFirst();
                return;
            }
        } else {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        this.userIdxCursor.afterValue(id, value);
        this.available = false;
    }

    @Override
    public void before(IndexEntry<V, Entry, ID> element) throws Exception {
        this.checkNotClosed("before()");
        if (this.userIdxCursor != null) {
            if (this.greaterEqEvaluator.getComparator().compare(element.getValue(), this.greaterEqEvaluator.getExpression().getValue().getValue()) <= 0) {
                this.beforeFirst();
                return;
            }
        } else {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        this.userIdxCursor.before((Entry)((Object)element));
        this.available = false;
    }

    @Override
    public void after(IndexEntry<V, Entry, ID> element) throws Exception {
        this.checkNotClosed("after()");
        if (this.userIdxCursor != null) {
            int comparedValue = this.greaterEqEvaluator.getComparator().compare(element.getValue(), this.greaterEqEvaluator.getExpression().getValue().getValue());
            if (comparedValue == 0) {
                this.userIdxCursor.after((Entry)((Object)element));
                this.available = false;
                return;
            }
            if (comparedValue < 0) {
                this.beforeFirst();
                return;
            }
        } else {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        this.userIdxCursor.after((Entry)((Object)element));
        this.available = false;
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        if (this.userIdxCursor != null) {
            ForwardIndexEntry advanceTo = new ForwardIndexEntry();
            advanceTo.setValue(this.greaterEqEvaluator.getExpression().getValue().getValue());
            this.userIdxCursor.before((Entry)((Object)advanceTo));
        } else {
            this.ndnIdxCursor.beforeFirst();
            this.ndnCandidate = null;
        }
        this.available = false;
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.afterLast();
        } else {
            this.ndnIdxCursor.afterLast();
            this.ndnCandidate = null;
        }
        this.available = false;
    }

    @Override
    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    @Override
    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    @Override
    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        if (this.userIdxCursor != null) {
            while (this.userIdxCursor.previous()) {
                this.checkNotClosed("previous()");
                IndexEntry candidate = (IndexEntry)this.userIdxCursor.get();
                if (this.greaterEqEvaluator.getComparator().compare(candidate.getValue(), this.greaterEqEvaluator.getExpression().getValue().getValue()) < 0) continue;
                this.available = true;
                return true;
            }
            this.available = false;
            return false;
        }
        while (this.ndnIdxCursor.previous()) {
            this.checkNotClosed("previous()");
            this.ndnCandidate = (IndexEntry)this.ndnIdxCursor.get();
            if (!this.greaterEqEvaluator.evaluate(this.ndnCandidate)) continue;
            this.available = true;
            return true;
        }
        this.available = false;
        return false;
    }

    @Override
    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        if (this.userIdxCursor != null) {
            this.available = this.userIdxCursor.next();
            return this.available;
        }
        while (this.ndnIdxCursor.next()) {
            this.checkNotClosed("next()");
            this.ndnCandidate = (IndexEntry)this.ndnIdxCursor.get();
            if (!this.greaterEqEvaluator.evaluate(this.ndnCandidate)) continue;
            this.available = true;
            return true;
        }
        this.available = false;
        return false;
    }

    @Override
    public IndexEntry<V, Entry, ID> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.userIdxCursor != null) {
            if (this.available) {
                return (IndexEntry)this.userIdxCursor.get();
            }
            throw new InvalidCursorPositionException(I18n.err(I18n.ERR_708, new Object[0]));
        }
        if (this.available) {
            return this.ndnCandidate;
        }
        throw new InvalidCursorPositionException(I18n.err(I18n.ERR_708, new Object[0]));
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.userIdxCursor != null) {
            this.userIdxCursor.close();
        } else {
            this.ndnIdxCursor.close();
        }
    }
}

