/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.controls.syncrepl_impl;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.Asn1Object;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.util.Asn1StringUtils;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.ControlDecorator;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.extras.controls.SyncModifyDn;
import org.apache.directory.shared.ldap.extras.controls.SyncModifyDnImpl;
import org.apache.directory.shared.ldap.extras.controls.SyncModifyDnType;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncModifyDnContainer;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncModifyDnTags;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncModifyDnDecorator
extends ControlDecorator<SyncModifyDn>
implements SyncModifyDn {
    private int syncModDnSeqLength;
    private int renameLen = 0;
    private int moveAndRenameLen = 0;
    private Asn1Decoder decoder = new Asn1Decoder();

    public SyncModifyDnDecorator(LdapApiService codec) {
        super(codec, new SyncModifyDnImpl());
    }

    public SyncModifyDnDecorator(LdapApiService codec, SyncModifyDnType type) {
        this(codec);
        ((SyncModifyDn)this.getDecorated()).setModDnType(type);
    }

    public SyncModifyDnDecorator(LdapApiService codec, SyncModifyDn control) {
        super(codec, control);
    }

    @Override
    public int computeLength() {
        String entryDn = ((SyncModifyDn)this.getDecorated()).getEntryDn();
        String newSuperiorDn = ((SyncModifyDn)this.getDecorated()).getNewSuperiorDn();
        String newRdn = ((SyncModifyDn)this.getDecorated()).getNewRdn();
        this.syncModDnSeqLength = 1 + TLV.getNbBytes(entryDn.length()) + entryDn.length();
        switch (((SyncModifyDn)this.getDecorated()).getModDnType()) {
            case MOVE: {
                int moveLen = 1 + TLV.getNbBytes(newSuperiorDn.length()) + newSuperiorDn.length();
                this.syncModDnSeqLength += moveLen;
                break;
            }
            case RENAME: {
                this.renameLen = 1 + TLV.getNbBytes(newRdn.length()) + newRdn.length();
                this.renameLen += 3;
                this.syncModDnSeqLength += 1 + TLV.getNbBytes(this.renameLen) + this.renameLen;
                break;
            }
            case MOVE_AND_RENAME: {
                this.moveAndRenameLen = 1 + TLV.getNbBytes(newSuperiorDn.length()) + newSuperiorDn.length();
                this.moveAndRenameLen += 1 + TLV.getNbBytes(newRdn.length()) + newRdn.length();
                this.moveAndRenameLen += 3;
                this.syncModDnSeqLength += 1 + TLV.getNbBytes(this.moveAndRenameLen) + this.moveAndRenameLen;
            }
        }
        this.valueLength = 1 + TLV.getNbBytes(this.syncModDnSeqLength) + this.syncModDnSeqLength;
        return this.valueLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_04023, new Object[0]));
        }
        buffer.put(UniversalTag.SEQUENCE.getValue());
        buffer.put(TLV.getBytes(this.syncModDnSeqLength));
        String entryDn = ((SyncModifyDn)this.getDecorated()).getEntryDn();
        String newSuperiorDn = ((SyncModifyDn)this.getDecorated()).getNewSuperiorDn();
        String newRdn = ((SyncModifyDn)this.getDecorated()).getNewRdn();
        Value.encode(buffer, entryDn);
        switch (((SyncModifyDn)this.getDecorated()).getModDnType()) {
            case MOVE: {
                buffer.put((byte)SyncModifyDnTags.MOVE_TAG.getValue());
                buffer.put(TLV.getBytes(newSuperiorDn.length()));
                buffer.put(Asn1StringUtils.getBytesUtf8(newSuperiorDn));
                break;
            }
            case RENAME: {
                buffer.put((byte)SyncModifyDnTags.RENAME_TAG.getValue());
                buffer.put(TLV.getBytes(this.renameLen));
                Value.encode(buffer, newRdn);
                Value.encode(buffer, ((SyncModifyDn)this.getDecorated()).isDeleteOldRdn());
                break;
            }
            case MOVE_AND_RENAME: {
                buffer.put((byte)SyncModifyDnTags.MOVEANDRENAME_TAG.getValue());
                buffer.put(TLV.getBytes(this.moveAndRenameLen));
                Value.encode(buffer, newSuperiorDn);
                Value.encode(buffer, newRdn);
                Value.encode(buffer, ((SyncModifyDn)this.getDecorated()).isDeleteOldRdn());
            }
        }
        return buffer;
    }

    @Override
    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                buffer.put(UniversalTag.SEQUENCE.getValue());
                buffer.put(TLV.getBytes(this.syncModDnSeqLength));
                String entryDn = ((SyncModifyDn)this.getDecorated()).getEntryDn();
                String newSuperiorDn = ((SyncModifyDn)this.getDecorated()).getNewSuperiorDn();
                String newRdn = ((SyncModifyDn)this.getDecorated()).getNewRdn();
                Value.encode(buffer, entryDn);
                switch (((SyncModifyDn)this.getDecorated()).getModDnType()) {
                    case MOVE: {
                        buffer.put((byte)SyncModifyDnTags.MOVE_TAG.getValue());
                        buffer.put(TLV.getBytes(newSuperiorDn.length()));
                        buffer.put(Asn1StringUtils.getBytesUtf8(newSuperiorDn));
                        break;
                    }
                    case RENAME: {
                        buffer.put((byte)SyncModifyDnTags.RENAME_TAG.getValue());
                        buffer.put(TLV.getBytes(this.renameLen));
                        Value.encode(buffer, newRdn);
                        Value.encode(buffer, ((SyncModifyDn)this.getDecorated()).isDeleteOldRdn());
                        break;
                    }
                    case MOVE_AND_RENAME: {
                        buffer.put((byte)SyncModifyDnTags.MOVEANDRENAME_TAG.getValue());
                        buffer.put(TLV.getBytes(this.moveAndRenameLen));
                        Value.encode(buffer, newSuperiorDn);
                        Value.encode(buffer, newRdn);
                        Value.encode(buffer, ((SyncModifyDn)this.getDecorated()).isDeleteOldRdn());
                    }
                }
                this.value = buffer.array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    @Override
    public String getEntryDn() {
        return ((SyncModifyDn)this.getDecorated()).getEntryDn();
    }

    @Override
    public void setEntryDn(String entryDn) {
        ((SyncModifyDn)this.getDecorated()).setEntryDn(entryDn);
    }

    @Override
    public String getNewSuperiorDn() {
        return ((SyncModifyDn)this.getDecorated()).getNewSuperiorDn();
    }

    @Override
    public void setNewSuperiorDn(String newSuperiorDn) {
        ((SyncModifyDn)this.getDecorated()).setNewSuperiorDn(newSuperiorDn);
    }

    @Override
    public String getNewRdn() {
        return ((SyncModifyDn)this.getDecorated()).getNewRdn();
    }

    @Override
    public void setNewRdn(String newRdn) {
        ((SyncModifyDn)this.getDecorated()).setNewRdn(newRdn);
    }

    @Override
    public boolean isDeleteOldRdn() {
        return ((SyncModifyDn)this.getDecorated()).isDeleteOldRdn();
    }

    @Override
    public void setDeleteOldRdn(boolean deleteOldRdn) {
        ((SyncModifyDn)this.getDecorated()).setDeleteOldRdn(deleteOldRdn);
    }

    @Override
    public SyncModifyDnType getModDnType() {
        return ((SyncModifyDn)this.getDecorated()).getModDnType();
    }

    @Override
    public void setModDnType(SyncModifyDnType modDnType) {
        if (((SyncModifyDn)this.getDecorated()).getModDnType() != null) {
            throw new IllegalStateException("cannot overwrite the existing modDnType value");
        }
        ((SyncModifyDn)this.getDecorated()).setModDnType(modDnType);
    }

    @Override
    public Asn1Object decode(byte[] controlBytes) throws DecoderException {
        ByteBuffer bb = ByteBuffer.wrap(controlBytes);
        SyncModifyDnContainer container = new SyncModifyDnContainer(this);
        this.decoder.decode(bb, container);
        return this;
    }
}

