/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.journal;

import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.journal.DefaultJournalStore;
import org.apache.directory.server.core.journal.Journal;
import org.apache.directory.server.core.journal.JournalStore;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.ldif.LdifEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJournal
implements Journal {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJournal.class);
    private boolean enabled;
    private JournalStore store;
    private int rotation;

    @Override
    public void destroy() throws Exception {
        LOG.debug("Stopping the journal");
        if (this.store != null) {
            this.store.destroy();
        }
    }

    @Override
    public JournalStore getJournalStore() {
        return this.store;
    }

    @Override
    public void init(DirectoryService directoryService) throws Exception {
        LOG.debug("Starting the journal");
        if (this.store == null) {
            this.store = new DefaultJournalStore();
        }
        this.store.init(directoryService);
        LOG.debug("The Journal service has been initialized");
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void log(LdapPrincipal principal, long revision, LdifEntry entry) throws LdapException {
        this.store.log(principal, revision, entry);
    }

    @Override
    public void ack(long revision) {
        this.store.ack(revision);
    }

    @Override
    public void nack(long revision) {
        this.store.nack(revision);
    }

    @Override
    public int getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setJournalStore(JournalStore store) {
        this.store = store;
    }
}

