/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.normalization;

import java.util.List;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.filtering.BaseEntryFilteringCursor;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.normalization.FilterNormalizingVisitor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.cursor.EmptyCursor;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidAttributeTypeException;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.name.Ava;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.normalizers.ConcreteNameComponentNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalizationInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(NormalizationInterceptor.class);
    private FilterNormalizingVisitor normVisitor;

    @Override
    public void init(DirectoryService directoryService) throws LdapException {
        LOG.debug("Initialiazing the NormalizationInterceptor");
        super.init(directoryService);
        ConcreteNameComponentNormalizer ncn = new ConcreteNameComponentNormalizer(this.schemaManager);
        this.normVisitor = new FilterNormalizingVisitor(ncn, this.schemaManager);
    }

    @Override
    public void destroy() {
    }

    @Override
    public void add(NextInterceptor nextInterceptor, AddOperationContext addContext) throws LdapException {
        addContext.getDn().apply(this.schemaManager);
        addContext.getEntry().getDn().apply(this.schemaManager);
        this.addRdnAttributesToEntry(addContext.getDn(), addContext.getEntry());
        nextInterceptor.add(addContext);
    }

    @Override
    public void delete(NextInterceptor nextInterceptor, DeleteOperationContext deleteContext) throws LdapException {
        Dn dn = deleteContext.getDn();
        if (!dn.isSchemaAware()) {
            dn.apply(this.schemaManager);
        }
        nextInterceptor.delete(deleteContext);
    }

    @Override
    public void modify(NextInterceptor nextInterceptor, ModifyOperationContext modifyContext) throws LdapException {
        if (!modifyContext.getDn().isSchemaAware()) {
            modifyContext.getDn().apply(this.schemaManager);
        }
        if (modifyContext.getModItems() != null) {
            for (Modification modification : modifyContext.getModItems()) {
                AttributeType attributeType = this.schemaManager.getAttributeType(modification.getAttribute().getId());
                modification.apply(attributeType);
            }
        }
        nextInterceptor.modify(modifyContext);
    }

    @Override
    public void rename(NextInterceptor nextInterceptor, RenameOperationContext renameContext) throws LdapException {
        if (!renameContext.getDn().isSchemaAware()) {
            renameContext.getDn().apply(this.schemaManager);
        }
        renameContext.getNewRdn().apply(this.schemaManager);
        if (!renameContext.getNewDn().isSchemaAware()) {
            renameContext.getNewDn().apply(this.schemaManager);
        }
        nextInterceptor.rename(renameContext);
    }

    @Override
    public void move(NextInterceptor nextInterceptor, MoveOperationContext moveContext) throws LdapException {
        if (!moveContext.getDn().isSchemaAware()) {
            moveContext.getDn().apply(this.schemaManager);
        }
        if (!moveContext.getOldSuperior().isSchemaAware()) {
            moveContext.getOldSuperior().apply(this.schemaManager);
        }
        if (!moveContext.getNewSuperior().isSchemaAware()) {
            moveContext.getNewSuperior().apply(this.schemaManager);
        }
        if (!moveContext.getNewDn().isSchemaAware()) {
            moveContext.getNewDn().apply(this.schemaManager);
        }
        if (!moveContext.getRdn().isSchemaAware()) {
            moveContext.getRdn().apply(this.schemaManager);
        }
        nextInterceptor.move(moveContext);
    }

    @Override
    public void moveAndRename(NextInterceptor nextInterceptor, MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        if (!moveAndRenameContext.getNewRdn().isSchemaAware()) {
            moveAndRenameContext.getNewRdn().apply(this.schemaManager);
        }
        if (!moveAndRenameContext.getDn().isSchemaAware()) {
            moveAndRenameContext.getDn().apply(this.schemaManager);
        }
        if (!moveAndRenameContext.getNewDn().isSchemaAware()) {
            moveAndRenameContext.getNewDn().apply(this.schemaManager);
        }
        if (!moveAndRenameContext.getNewSuperiorDn().isSchemaAware()) {
            moveAndRenameContext.getNewSuperiorDn().apply(this.schemaManager);
        }
        nextInterceptor.moveAndRename(moveAndRenameContext);
    }

    @Override
    public EntryFilteringCursor search(NextInterceptor nextInterceptor, SearchOperationContext searchContext) throws LdapException {
        ExprNode filter;
        Dn dn = searchContext.getDn();
        if (!dn.isSchemaAware()) {
            dn.apply(this.schemaManager);
        }
        if ((filter = searchContext.getFilter()) == null) {
            LOG.warn("undefined filter based on undefined attributeType not evaluted at all.  Returning empty enumeration.");
            return new BaseEntryFilteringCursor(new EmptyCursor<Entry>(), searchContext);
        }
        if ((filter = (ExprNode)filter.accept(this.normVisitor)) == null) {
            LOG.warn("undefined filter based on undefined attributeType not evaluted at all.  Returning empty enumeration.");
            return new BaseEntryFilteringCursor(new EmptyCursor<Entry>(), searchContext);
        }
        searchContext.setFilter(filter);
        return nextInterceptor.search(searchContext);
    }

    @Override
    public boolean hasEntry(NextInterceptor nextInterceptor, EntryOperationContext hasEntryContext) throws LdapException {
        hasEntryContext.getDn().apply(this.schemaManager);
        return nextInterceptor.hasEntry(hasEntryContext);
    }

    @Override
    public EntryFilteringCursor list(NextInterceptor nextInterceptor, ListOperationContext listContext) throws LdapException {
        listContext.getDn().apply(this.schemaManager);
        return nextInterceptor.list(listContext);
    }

    private String[] normalizeAttrsId(String[] attrIds) throws LdapException {
        if (attrIds == null) {
            return attrIds;
        }
        String[] normalizedAttrIds = new String[attrIds.length];
        int pos = 0;
        for (String id : attrIds) {
            String oid = this.schemaManager.lookupAttributeTypeRegistry(id).getOid();
            normalizedAttrIds[pos++] = oid;
        }
        return normalizedAttrIds;
    }

    @Override
    public Entry lookup(NextInterceptor nextInterceptor, LookupOperationContext lookupContext) throws LdapException {
        lookupContext.getDn().apply(this.schemaManager);
        List<String> attrIds = lookupContext.getAttrsId();
        if (attrIds != null && attrIds.size() > 0) {
            lookupContext.setAttrsId(this.normalizeAttrsId(lookupContext.getAttrsIdArray()));
        }
        return nextInterceptor.lookup(lookupContext);
    }

    @Override
    public boolean compare(NextInterceptor next, CompareOperationContext compareContext) throws LdapException {
        if (!compareContext.getDn().isSchemaAware()) {
            compareContext.getDn().apply(this.schemaManager);
        }
        try {
            AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(compareContext.getOid());
            if (attributeType.getSyntax().isHumanReadable() && !compareContext.getValue().isHumanReadable()) {
                String value = compareContext.getValue().getString();
                compareContext.setValue(new StringValue(value));
            }
            compareContext.setAttributeType(attributeType);
        }
        catch (LdapException le) {
            throw new LdapInvalidAttributeTypeException(I18n.err(I18n.ERR_266, compareContext.getOid()));
        }
        return next.compare(compareContext);
    }

    @Override
    public void bind(NextInterceptor next, BindOperationContext bindContext) throws LdapException {
        bindContext.getDn().apply(this.schemaManager);
        next.bind(bindContext);
    }

    private void addRdnAttributesToEntry(Dn dn, Entry entry) throws LdapException {
        if (dn == null || entry == null) {
            return;
        }
        Rdn rdn = dn.getRdn();
        for (Ava ava : rdn) {
            Value<?> value = ava.getNormValue();
            Value<?> upValue = ava.getUpValue();
            String upId = ava.getUpType();
            if (entry.contains(upId, value)) continue;
            String message = "The Rdn '" + upId + "=" + upValue + "' is not present in the entry";
            LOG.warn(message);
            if (!entry.containsAttribute(upId)) {
                entry.add(upId, value);
                continue;
            }
            AttributeType at = this.schemaManager.lookupAttributeTypeRegistry(upId);
            if (at.isSingleValued()) {
                entry.removeAttributes(upId);
                entry.add(upId, value);
                continue;
            }
            entry.add(upId, value);
        }
    }
}

