/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.List;
import org.apache.directory.shared.ldap.model.name.Rdn;

public class ParentIdAndRdn<ID extends Comparable<ID>>
implements Externalizable,
Comparable<ParentIdAndRdn<ID>> {
    protected ID parentId;
    protected Rdn[] rdns;

    public ParentIdAndRdn() {
    }

    public ParentIdAndRdn(ID parentId, Rdn ... rdns) {
        this.parentId = parentId;
        this.rdns = rdns;
    }

    public ParentIdAndRdn(ID parentId, List<Rdn> rdns) {
        this.parentId = parentId;
        this.rdns = rdns.toArray(new Rdn[rdns.size()]);
    }

    public ID getParentId() {
        return this.parentId;
    }

    public void setParentId(ID parentId) {
        this.parentId = parentId;
    }

    public Rdn[] getRdns() {
        return this.rdns;
    }

    public void setRdns(Rdn[] rdns) {
        this.rdns = rdns;
    }

    public int hashCode() {
        int h = 37;
        h = h * 17 + (this.parentId == null ? 0 : this.parentId.hashCode());
        h = h * 17 + Arrays.hashCode(this.rdns);
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ParentIdAndRdn)) {
            return false;
        }
        ParentIdAndRdn that = (ParentIdAndRdn)obj;
        if (this.rdns == null) {
            return that.rdns == null;
        }
        if (that.rdns == null) {
            return false;
        }
        if (this.rdns.length != that.rdns.length) {
            return false;
        }
        for (int i = 0; i < this.rdns.length; ++i) {
            if (this.rdns[i].equals(that.rdns[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(ParentIdAndRdn<ID> that) {
        int val = this.rdns.length - that.rdns.length;
        if (val != 0) {
            return val;
        }
        for (int i = 0; i < this.rdns.length; ++i) {
            val = this.rdns[i].getNormName().compareTo(that.rdns[i].getNormName());
            if (val == 0) continue;
            return val;
        }
        val = this.getParentId().compareTo(that.getParentId());
        return val;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.parentId);
        out.writeInt(this.rdns.length);
        for (Rdn rdn : this.rdns) {
            rdn.writeExternal(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.parentId = (Comparable)in.readObject();
        int size = in.readInt();
        this.rdns = new Rdn[size];
        for (int i = 0; i < size; ++i) {
            Rdn rdn = new Rdn();
            rdn.readExternal(in);
            this.rdns[i] = rdn;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ParentIdAndRdn<");
        sb.append(this.parentId).append(", '");
        boolean isFirst = true;
        for (Rdn rdn : this.rdns) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(rdn);
        }
        sb.append("'>");
        return sb.toString();
    }
}

