/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.resolver;

import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import org.apache.felix.framework.capabilityset.Capability;
import org.apache.felix.framework.capabilityset.Requirement;
import org.apache.felix.framework.resolver.Module;
import org.apache.felix.framework.resolver.ResourceNotFoundException;
import org.apache.felix.framework.resolver.Wire;
import org.apache.felix.framework.util.Util;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WireModuleImpl
implements Wire {
    private final Module m_importer;
    private final Requirement m_req;
    private final Module m_exporter;
    private final Capability m_cap;
    private final List<String> m_packages;

    public WireModuleImpl(Module importer, Requirement requirement, Module exporter, Capability capability, List<String> packages) {
        this.m_importer = importer;
        this.m_req = requirement;
        this.m_exporter = exporter;
        this.m_cap = capability;
        this.m_packages = packages;
    }

    @Override
    public Module getImporter() {
        return this.m_importer;
    }

    @Override
    public Requirement getRequirement() {
        return this.m_req;
    }

    @Override
    public Module getExporter() {
        return this.m_exporter;
    }

    @Override
    public Capability getCapability() {
        return this.m_cap;
    }

    @Override
    public boolean hasPackage(String pkgName) {
        return this.m_packages.contains(pkgName);
    }

    @Override
    public Class getClass(String name) throws ClassNotFoundException {
        String pkgName = Util.getClassPackage(name);
        if (this.m_packages.contains(pkgName)) {
            try {
                Class clazz = this.m_exporter.getClassByDelegation(name);
                if (clazz != null) {
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public URL getResource(String name) throws ResourceNotFoundException {
        URL url;
        String pkgName = Util.getResourcePackage(name);
        if (this.m_packages.contains(pkgName) && (url = this.m_exporter.getResourceByDelegation(name)) != null) {
            return url;
        }
        return null;
    }

    @Override
    public Enumeration getResources(String name) throws ResourceNotFoundException {
        Enumeration urls;
        String pkgName = Util.getResourcePackage(name);
        if (this.m_packages.contains(pkgName) && (urls = this.m_exporter.getResourcesByDelegation(name)) != null && urls.hasMoreElements()) {
            return urls;
        }
        return null;
    }

    public String toString() {
        return new StringBuffer().append(this.m_req).append(" -> ").append("[").append(this.m_exporter).append("]").toString();
    }
}

