/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.normalization;

import java.util.Iterator;
import java.util.List;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.filter.ApproximateNode;
import org.apache.directory.shared.ldap.model.filter.BranchNode;
import org.apache.directory.shared.ldap.model.filter.EqualityNode;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.filter.ExtensibleNode;
import org.apache.directory.shared.ldap.model.filter.FilterVisitor;
import org.apache.directory.shared.ldap.model.filter.GreaterEqNode;
import org.apache.directory.shared.ldap.model.filter.LeafNode;
import org.apache.directory.shared.ldap.model.filter.LessEqNode;
import org.apache.directory.shared.ldap.model.filter.OrNode;
import org.apache.directory.shared.ldap.model.filter.PresenceNode;
import org.apache.directory.shared.ldap.model.filter.SubstringNode;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;

public class ExpandingVisitor
implements FilterVisitor {
    private SchemaManager schemaManager;

    public ExpandingVisitor(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    @Override
    public boolean canVisit(ExprNode node) {
        return node instanceof BranchNode;
    }

    @Override
    public List<ExprNode> getOrder(BranchNode node, List<ExprNode> children) {
        return children;
    }

    @Override
    public boolean isPrefix() {
        return false;
    }

    @Override
    public Object visit(ExprNode node) {
        BranchNode bnode = (BranchNode)node;
        List<ExprNode> children = bnode.getChildren();
        int childNumber = 0;
        for (ExprNode child : children) {
            if (child instanceof LeafNode) {
                LeafNode leaf = (LeafNode)child;
                try {
                    if (!this.schemaManager.getAttributeTypeRegistry().hasDescendants(leaf.getAttributeType())) continue;
                    OrNode orNode = new OrNode();
                    orNode.getChildren().add(leaf);
                    children.set(childNumber++, orNode);
                    Iterator<AttributeType> descendants = this.schemaManager.getAttributeTypeRegistry().descendants(leaf.getAttributeType());
                    while (descendants.hasNext()) {
                        LeafNode newLeaf = null;
                        AttributeType descendant = descendants.next();
                        if (leaf instanceof PresenceNode) {
                            newLeaf = new PresenceNode(descendant);
                        } else if (leaf instanceof ApproximateNode) {
                            ApproximateNode approximateNode = (ApproximateNode)leaf;
                            newLeaf = new ApproximateNode(descendant, approximateNode.getValue());
                        } else if (leaf instanceof EqualityNode) {
                            EqualityNode equalityNode = (EqualityNode)leaf;
                            newLeaf = new EqualityNode(descendant, equalityNode.getValue());
                        } else if (leaf instanceof GreaterEqNode) {
                            GreaterEqNode greaterEqNode = (GreaterEqNode)leaf;
                            newLeaf = new GreaterEqNode(descendant, greaterEqNode.getValue());
                        } else if (leaf instanceof LessEqNode) {
                            LessEqNode lessEqNode = (LessEqNode)leaf;
                            newLeaf = new LessEqNode(descendant, lessEqNode.getValue());
                        } else if (leaf instanceof ExtensibleNode) {
                            ExtensibleNode extensibleNode = (ExtensibleNode)leaf;
                            newLeaf = new ExtensibleNode(descendant, extensibleNode.getValue(), extensibleNode.getMatchingRuleId(), extensibleNode.hasDnAttributes());
                        } else if (leaf instanceof SubstringNode) {
                            SubstringNode substringNode = (SubstringNode)leaf;
                            newLeaf = new SubstringNode(descendant, substringNode.getInitial(), substringNode.getFinal());
                        } else {
                            throw new IllegalStateException(I18n.err(I18n.ERR_260, leaf));
                        }
                        orNode.addNode(newLeaf);
                    }
                    continue;
                }
                catch (LdapException e) {
                    throw new RuntimeException(I18n.err(I18n.ERR_261, new Object[0]));
                }
            }
            this.visit(child);
        }
        return null;
    }
}

