/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.abandonRequest;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.AbandonRequestDecorator;
import org.apache.directory.shared.ldap.model.message.AbandonRequestImpl;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitAbandonRequest
extends GrammarAction<LdapMessageContainer<AbandonRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitAbandonRequest.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public InitAbandonRequest() {
        super("Init Abandon Request");
    }

    @Override
    public void action(LdapMessageContainer<AbandonRequestDecorator> container) throws DecoderException {
        AbandonRequestImpl internalAbandonRequest = new AbandonRequestImpl();
        internalAbandonRequest.setMessageId(container.getMessageId());
        AbandonRequestDecorator abandonRequest = new AbandonRequestDecorator(container.getLdapCodecService(), internalAbandonRequest);
        container.setMessage(abandonRequest);
        TLV tlv = container.getCurrentTLV();
        Value value = tlv.getValue();
        if (value == null || value.getData() == null) {
            String msg = I18n.err(I18n.ERR_04075, new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        try {
            int abandonnedMessageId = IntegerDecoder.parse(value, 0, Integer.MAX_VALUE);
            abandonRequest.setAbandoned(abandonnedMessageId);
            if (IS_DEBUG) {
                LOG.debug("AbandonMessage Id has been decoded : {}", abandonnedMessageId);
            }
            container.setGrammarEndAllowed(true);
            return;
        }
        catch (IntegerDecoderException ide) {
            LOG.error(I18n.err(I18n.ERR_04076, Strings.dumpBytes(value.getData()), ide.getMessage()));
            throw new DecoderException(ide.getMessage(), ide);
        }
    }
}

