/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.compareRequest;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.shared.ldap.codec.decorators.CompareRequestDecorator;
import org.apache.directory.shared.ldap.model.message.CompareRequest;
import org.apache.directory.shared.ldap.model.message.CompareResponseImpl;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreCompareRequestAttributeDesc
extends GrammarAction<LdapMessageContainer<CompareRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreCompareRequestAttributeDesc.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreCompareRequestAttributeDesc() {
        super("Store CompareRequest assertion description");
    }

    @Override
    public void action(LdapMessageContainer<CompareRequestDecorator> container) throws DecoderException {
        CompareRequest compareRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err(I18n.ERR_04093, new Object[0]);
            LOG.error(msg);
            CompareResponseImpl response = new CompareResponseImpl(compareRequest.getMessageId());
            throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, compareRequest.getName(), null);
        }
        String type = Strings.utf8ToString(tlv.getValue().getData());
        compareRequest.setAttributeId(type);
        if (IS_DEBUG) {
            LOG.debug("Comparing attribute description {}", (Object)compareRequest.getAttributeId());
        }
    }
}

