/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.search.Filter;
import org.apache.directory.shared.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstringFilter
extends Filter {
    private String type;
    private int typeLength;
    private int substringsLength;
    private String initialSubstrings;
    private List<String> anySubstrings = new ArrayList<String>(1);
    private String finalSubstrings;
    private int substringsFilterLength;
    private int substringsFilterSequenceLength;

    public SubstringFilter(int tlvId) {
        super(tlvId);
    }

    public SubstringFilter() {
    }

    public List<String> getAnySubstrings() {
        return this.anySubstrings;
    }

    public void addAnySubstrings(String any) {
        this.anySubstrings.add(any);
    }

    public String getFinalSubstrings() {
        return this.finalSubstrings;
    }

    public void setFinalSubstrings(String finalSubstrings) {
        this.finalSubstrings = finalSubstrings;
    }

    public String getInitialSubstrings() {
        return this.initialSubstrings;
    }

    public void setInitialSubstrings(String initialSubstrings) {
        this.initialSubstrings = initialSubstrings;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getSubstringsLength() {
        return this.substringsLength;
    }

    public void setSubstringsLength(int substringsLength) {
        this.substringsLength = substringsLength;
    }

    @Override
    public int computeLength() {
        this.typeLength = Strings.getBytesUtf8(this.type).length;
        this.substringsFilterLength = 1 + TLV.getNbBytes(this.typeLength) + this.typeLength;
        this.substringsFilterSequenceLength = 0;
        if (this.initialSubstrings != null) {
            int initialLength = Strings.getBytesUtf8(this.initialSubstrings).length;
            this.substringsFilterSequenceLength += 1 + TLV.getNbBytes(initialLength) + initialLength;
        }
        if (this.anySubstrings != null) {
            for (String any : this.anySubstrings) {
                int anyLength = Strings.getBytesUtf8(any).length;
                this.substringsFilterSequenceLength += 1 + TLV.getNbBytes(anyLength) + anyLength;
            }
        }
        if (this.finalSubstrings != null) {
            int finalLength = Strings.getBytesUtf8(this.finalSubstrings).length;
            this.substringsFilterSequenceLength += 1 + TLV.getNbBytes(finalLength) + finalLength;
        }
        this.substringsFilterLength += 1 + TLV.getNbBytes(this.substringsFilterSequenceLength) + this.substringsFilterSequenceLength;
        return 1 + TLV.getNbBytes(this.substringsFilterLength) + this.substringsFilterLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_04023, new Object[0]));
        }
        try {
            buffer.put((byte)-92);
            buffer.put(TLV.getBytes(this.substringsFilterLength));
            Value.encode(buffer, this.type.getBytes());
            buffer.put(UniversalTag.SEQUENCE.getValue());
            buffer.put(TLV.getBytes(this.substringsFilterSequenceLength));
            if (this.initialSubstrings == null && (this.anySubstrings == null || this.anySubstrings.size() == 0) && this.finalSubstrings == null) {
                throw new EncoderException(I18n.err(I18n.ERR_04058, new Object[0]));
            }
            if (this.initialSubstrings != null) {
                byte[] initialBytes = Strings.getBytesUtf8(this.initialSubstrings);
                buffer.put((byte)-128);
                buffer.put(TLV.getBytes(initialBytes.length));
                buffer.put(initialBytes);
            }
            if (this.anySubstrings != null) {
                for (String any : this.anySubstrings) {
                    byte[] anyBytes = Strings.getBytesUtf8(any);
                    buffer.put((byte)-127);
                    buffer.put(TLV.getBytes(anyBytes.length));
                    buffer.put(anyBytes);
                }
            }
            if (this.finalSubstrings != null) {
                byte[] finalBytes = Strings.getBytesUtf8(this.finalSubstrings);
                buffer.put((byte)-126);
                buffer.put(TLV.getBytes(finalBytes.length));
                buffer.put(finalBytes);
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_04005, new Object[0]));
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.initialSubstrings != null) {
            sb.append(this.initialSubstrings);
        }
        sb.append('*');
        if (this.anySubstrings != null) {
            for (String any : this.anySubstrings) {
                sb.append(any).append('*');
            }
        }
        if (this.finalSubstrings != null) {
            sb.append(this.finalSubstrings);
        }
        return sb.toString();
    }
}

