/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.messages;

import java.util.Map;
import org.apache.directory.server.dns.messages.RecordClass;
import org.apache.directory.server.dns.messages.RecordType;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.shared.util.Strings;

public class ResourceRecordImpl
implements ResourceRecord {
    private String domainName;
    private RecordType recordType;
    private RecordClass recordClass;
    private int timeToLive;
    private Map<String, Object> attributes;

    public ResourceRecordImpl(String domainName, RecordType recordType, RecordClass recordClass, int timeToLive, Map<String, Object> attributes) {
        this.domainName = domainName;
        this.recordType = recordType;
        this.recordClass = recordClass;
        this.timeToLive = timeToLive;
        this.attributes = attributes;
    }

    @Override
    public String getDomainName() {
        return this.domainName;
    }

    @Override
    public RecordType getRecordType() {
        return this.recordType;
    }

    @Override
    public RecordClass getRecordClass() {
        return this.recordClass;
    }

    @Override
    public int getTimeToLive() {
        return this.timeToLive;
    }

    @Override
    public String get(String id) {
        return (String)this.attributes.get(Strings.toLowerCase(id));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceRecord)) {
            return false;
        }
        ResourceRecordImpl that = (ResourceRecordImpl)o;
        return this.domainName.equalsIgnoreCase(that.domainName) && this.recordType == that.recordType && this.recordClass == that.recordClass;
    }

    public int hashCode() {
        return this.domainName.hashCode() + this.recordType.hashCode() + this.recordClass.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + " [ " + this.domainName + " ( " + this.recordType + " " + this.recordClass + " " + this.timeToLive + " " + this.attributes + " ) ]";
    }
}

