/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.entry.Entry;

public class SingletonIndexCursor<V, ID>
extends AbstractIndexCursor<V, Entry, ID> {
    private boolean beforeFirst = true;
    private boolean afterLast;
    private boolean onSingleton;
    private final IndexEntry<V, ID> singleton;

    public SingletonIndexCursor(IndexEntry<V, ID> singleton) {
        this.singleton = singleton;
    }

    @Override
    protected String getUnsupportedMessage() {
        return "Unsupported operation";
    }

    @Override
    public boolean available() {
        return this.onSingleton;
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("()");
        this.beforeFirst = true;
        this.afterLast = false;
        this.onSingleton = false;
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("()");
        this.beforeFirst = false;
        this.afterLast = true;
        this.onSingleton = false;
    }

    @Override
    public boolean first() throws Exception {
        this.checkNotClosed("()");
        this.beforeFirst = false;
        this.onSingleton = true;
        this.afterLast = false;
        return true;
    }

    @Override
    public boolean last() throws Exception {
        this.checkNotClosed("()");
        this.beforeFirst = false;
        this.onSingleton = true;
        this.afterLast = false;
        return true;
    }

    @Override
    public boolean isFirst() throws Exception {
        this.checkNotClosed("()");
        return this.onSingleton;
    }

    @Override
    public boolean isLast() throws Exception {
        this.checkNotClosed("()");
        return this.onSingleton;
    }

    @Override
    public boolean isAfterLast() throws Exception {
        this.checkNotClosed("()");
        return this.afterLast;
    }

    @Override
    public boolean isBeforeFirst() throws Exception {
        this.checkNotClosed("()");
        return this.beforeFirst;
    }

    @Override
    public boolean previous() throws Exception {
        this.checkNotClosed("()");
        if (this.beforeFirst) {
            return false;
        }
        if (this.afterLast) {
            this.beforeFirst = false;
            this.onSingleton = true;
            this.afterLast = false;
            return true;
        }
        this.beforeFirst = true;
        this.onSingleton = false;
        this.afterLast = false;
        return false;
    }

    @Override
    public boolean next() throws Exception {
        this.checkNotClosed("()");
        if (this.beforeFirst) {
            this.beforeFirst = false;
            this.onSingleton = true;
            this.afterLast = false;
            return true;
        }
        if (this.afterLast) {
            return false;
        }
        this.beforeFirst = false;
        this.onSingleton = false;
        this.afterLast = true;
        return false;
    }

    @Override
    public IndexEntry<V, ID> get() throws Exception {
        this.checkNotClosed("()");
        if (this.onSingleton) {
            return this.singleton;
        }
        if (this.beforeFirst) {
            throw new InvalidCursorPositionException(I18n.err(I18n.ERR_705, new Object[0]));
        }
        throw new InvalidCursorPositionException(I18n.err(I18n.ERR_706, new Object[0]));
    }
}

