/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.codec.decorators.SingleReplyRequestDecorator;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultAttribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.MessageException;
import org.apache.directory.shared.ldap.model.message.AddRequest;
import org.apache.directory.shared.ldap.model.message.AddResponse;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.ldap.model.name.Dn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AddRequestDecorator
extends SingleReplyRequestDecorator<AddRequest, AddResponse>
implements AddRequest {
    private int addRequestLength;
    private int entryLength;
    private List<Integer> attributesLength;
    private List<Integer> valuesLength;
    private Attribute currentAttribute;

    public AddRequestDecorator(LdapApiService codec, AddRequest decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public void setAddRequestLength(int addRequestLength) {
        this.addRequestLength = addRequestLength;
    }

    public int getAddRequestLength() {
        return this.addRequestLength;
    }

    public void setEntryLength(int entryLength) {
        this.entryLength = entryLength;
    }

    public int getEntryLength() {
        return this.entryLength;
    }

    public void setAttributesLength(List<Integer> attributesLength) {
        this.attributesLength = attributesLength;
    }

    public List<Integer> getAttributesLength() {
        return this.attributesLength;
    }

    public void setValuesLength(List<Integer> valuesLength) {
        this.valuesLength = valuesLength;
    }

    public List<Integer> getValuesLength() {
        return this.valuesLength;
    }

    @Override
    public AddRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    @Override
    public AddRequest addControl(Control control) throws MessageException {
        return (AddRequest)super.addControl(control);
    }

    @Override
    public AddRequest addAllControls(Control[] controls) throws MessageException {
        return (AddRequest)super.addAllControls(controls);
    }

    @Override
    public AddRequest removeControl(Control control) throws MessageException {
        return (AddRequest)super.removeControl(control);
    }

    @Override
    public Dn getEntryDn() {
        return ((AddRequest)this.getDecorated()).getEntryDn();
    }

    @Override
    public AddRequest setEntryDn(Dn entry) {
        ((AddRequest)this.getDecorated()).setEntryDn(entry);
        return this;
    }

    @Override
    public Entry getEntry() {
        return ((AddRequest)this.getDecorated()).getEntry();
    }

    @Override
    public AddRequest setEntry(Entry entry) {
        ((AddRequest)this.getDecorated()).setEntry(entry);
        return this;
    }

    public void addAttributeType(String type) throws LdapException {
        if (((AddRequest)this.getDecorated()).getEntry().get(type) != null) {
            this.currentAttribute = ((AddRequest)this.getDecorated()).getEntry().get(type);
            return;
        }
        this.currentAttribute = new DefaultAttribute(type);
        ((AddRequest)this.getDecorated()).getEntry().put(this.currentAttribute);
    }

    public String getCurrentAttributeType() {
        return this.currentAttribute.getUpId();
    }

    public void addAttributeValue(String value) throws LdapException {
        this.currentAttribute.add(value);
    }

    public void addAttributeValue(Value<?> value) throws LdapException {
        this.currentAttribute.add(value);
    }

    public void addAttributeValue(byte[] value) throws LdapException {
        this.currentAttribute.add(new byte[][]{value});
    }

    @Override
    public int computeLength() {
        AddRequest addRequest = (AddRequest)this.getDecorated();
        Entry entry = addRequest.getEntry();
        if (entry == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_04481_ENTRY_NULL_VALUE, new Object[0]));
        }
        int addRequestLength = 1 + TLV.getNbBytes(Dn.getNbBytes(entry.getDn())) + Dn.getNbBytes(entry.getDn());
        int entryLength = 0;
        if (entry.size() != 0) {
            LinkedList<Integer> attributesLength = new LinkedList<Integer>();
            LinkedList<Integer> valuesLength = new LinkedList<Integer>();
            for (Attribute attribute : entry) {
                int localAttributeLength = 0;
                int localValuesLength = 0;
                int idLength = attribute.getUpId().getBytes().length;
                localAttributeLength = 1 + TLV.getNbBytes(idLength) + idLength;
                if (attribute.size() != 0) {
                    localValuesLength = 0;
                    for (Value value : attribute) {
                        int valueLength = value.getBytes().length;
                        localValuesLength += 1 + TLV.getNbBytes(valueLength) + valueLength;
                    }
                    localAttributeLength += 1 + TLV.getNbBytes(localValuesLength) + localValuesLength;
                }
                entryLength += 1 + TLV.getNbBytes(localAttributeLength) + localAttributeLength;
                attributesLength.add(localAttributeLength);
                valuesLength.add(localValuesLength);
            }
            this.setAttributesLength(attributesLength);
            this.setValuesLength(valuesLength);
            this.setEntryLength(entryLength);
        }
        this.setAddRequestLength(addRequestLength += 1 + TLV.getNbBytes(entryLength) + entryLength);
        return 1 + TLV.getNbBytes(addRequestLength) + addRequestLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)104);
            buffer.put(TLV.getBytes(this.getAddRequestLength()));
            org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, Dn.getBytes(this.getEntryDn()));
            buffer.put(UniversalTag.SEQUENCE.getValue());
            buffer.put(TLV.getBytes(this.getEntryLength()));
            Entry entry = this.getEntry();
            if (entry.size() != 0) {
                int attributeNumber = 0;
                for (Attribute attribute : entry) {
                    buffer.put(UniversalTag.SEQUENCE.getValue());
                    int localAttributeLength = this.getAttributesLength().get(attributeNumber);
                    buffer.put(TLV.getBytes(localAttributeLength));
                    org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, attribute.getUpId());
                    buffer.put(UniversalTag.SET.getValue());
                    int localValuesLength = this.getValuesLength().get(attributeNumber);
                    buffer.put(TLV.getBytes(localValuesLength));
                    if (attribute.size() != 0) {
                        for (Value value : attribute) {
                            if (value.isHumanReadable()) {
                                org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, value.getString());
                                continue;
                            }
                            org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, value.getBytes());
                        }
                    }
                    ++attributeNumber;
                }
            }
            return buffer;
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
    }
}

