/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.syntaxCheckers;

import org.apache.directory.shared.ldap.model.schema.SyntaxChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpegSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(JpegSyntaxChecker.class);

    public JpegSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.28");
    }

    public boolean isValidSyntax(Object value) {
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        if (!(value instanceof byte[])) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        byte[] bytes = (byte[])value;
        if (bytes.length < 11) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        if (bytes[0] == -1 && bytes[1] == -40 && bytes[2] == -1 && bytes[3] == -32 && bytes[6] == 74 && bytes[7] == 70 && bytes[8] == 73 && bytes[9] == 70 && bytes[10] == 0) {
            LOG.debug("Syntax valid for '{}'", value);
            return true;
        }
        LOG.debug("Syntax invalid for '{}'", value);
        return false;
    }
}

