/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.IOException;
import jdbm.helper.TupleBrowser;
import org.apache.directory.server.core.partition.impl.btree.jdbm.DupsContainer;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmTable;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.cursor.AbstractTupleCursor;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.cursor.Tuple;

public class DupsContainerCursor<K, V>
extends AbstractTupleCursor<K, DupsContainer<V>> {
    private final JdbmTable<K, V> table;
    private jdbm.helper.Tuple<K, V> jdbmTuple = new jdbm.helper.Tuple();
    private Tuple<K, DupsContainer<V>> returnedTuple = new Tuple();
    private TupleBrowser<K, V> browser;
    private boolean valueAvailable;
    private Boolean forwardDirection;

    public DupsContainerCursor(JdbmTable<K, V> table) throws IOException {
        if (!table.isDupsEnabled()) {
            throw new IllegalStateException(I18n.err(I18n.ERR_572, new Object[0]));
        }
        this.table = table;
    }

    private void clearValue() {
        this.returnedTuple.setKey(null);
        this.returnedTuple.setValue(null);
        this.jdbmTuple.setKey(null);
        this.jdbmTuple.setValue(null);
        this.valueAvailable = false;
    }

    @Override
    public boolean available() {
        return this.valueAvailable;
    }

    @Override
    public void beforeKey(K key) throws Exception {
        this.checkNotClosed("beforeKey()");
        this.closeBrowser(this.browser);
        this.browser = this.table.getBTree().browse(key);
        this.forwardDirection = null;
        this.clearValue();
    }

    @Override
    public void afterKey(K key) throws Exception {
        this.checkNotClosed("afterKey()");
        this.closeBrowser(this.browser);
        this.browser = this.table.getBTree().browse(key);
        this.forwardDirection = null;
        while (this.browser.getNext(this.jdbmTuple)) {
            this.checkNotClosed("afterKey()");
            K next = this.jdbmTuple.getKey();
            int nextCompared = this.table.getKeyComparator().compare(next, key);
            if (nextCompared <= 0) continue;
            this.browser.getPrevious(this.jdbmTuple);
            this.browser.getPrevious(this.jdbmTuple);
            this.forwardDirection = false;
            this.clearValue();
            return;
        }
        this.clearValue();
    }

    @Override
    public void beforeValue(K key, DupsContainer<V> value) throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_573, new Object[0]));
    }

    @Override
    public void afterValue(K key, DupsContainer<V> value) throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_573, new Object[0]));
    }

    @Override
    public void before(Tuple<K, DupsContainer<V>> element) throws Exception {
        this.beforeKey(element.getKey());
    }

    @Override
    public void after(Tuple<K, DupsContainer<V>> element) throws Exception {
        this.afterKey(element.getKey());
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.closeBrowser(this.browser);
        this.browser = this.table.getBTree().browse();
        this.forwardDirection = null;
        this.clearValue();
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.closeBrowser(this.browser);
        this.browser = this.table.getBTree().browse(null);
        this.forwardDirection = null;
        this.clearValue();
    }

    @Override
    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    @Override
    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        if (this.browser == null) {
            this.afterLast();
        }
        boolean advanceSuccess = this.browser.getPrevious(this.jdbmTuple);
        if (this.forwardDirection == null) {
            if (!advanceSuccess) {
                this.clearValue();
                return false;
            }
            this.forwardDirection = false;
        } else if (this.forwardDirection.booleanValue()) {
            advanceSuccess = this.browser.getPrevious(this.jdbmTuple);
            this.forwardDirection = false;
        }
        this.valueAvailable = advanceSuccess;
        if (this.valueAvailable) {
            this.returnedTuple.setKey(this.jdbmTuple.getKey());
            this.returnedTuple.setValue(this.table.getDupsContainer((byte[])this.jdbmTuple.getValue()));
            return this.valueAvailable;
        }
        this.clearValue();
        return this.valueAvailable;
    }

    @Override
    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        if (this.browser == null) {
            this.beforeFirst();
        }
        boolean advanceSuccess = this.browser.getNext(this.jdbmTuple);
        if (this.forwardDirection == null) {
            if (advanceSuccess) {
                this.forwardDirection = true;
            } else {
                this.clearValue();
                return false;
            }
        }
        if (!this.forwardDirection.booleanValue()) {
            advanceSuccess = this.browser.getNext(this.jdbmTuple);
            this.forwardDirection = true;
        }
        this.valueAvailable = advanceSuccess;
        if (this.valueAvailable) {
            this.returnedTuple.setKey(this.jdbmTuple.getKey());
            this.returnedTuple.setValue(this.table.getDupsContainer((byte[])this.jdbmTuple.getValue()));
        } else {
            this.clearValue();
        }
        return this.valueAvailable;
    }

    @Override
    public Tuple<K, DupsContainer<V>> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.valueAvailable) {
            return this.returnedTuple;
        }
        throw new InvalidCursorPositionException();
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.closeBrowser(this.browser);
    }

    @Override
    public void close(Exception cause) throws Exception {
        super.close(cause);
        this.closeBrowser(this.browser);
    }

    private void closeBrowser(TupleBrowser browser) {
        if (browser != null) {
            browser.close();
        }
    }
}

