/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.ldif;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.naming.InvalidNameException;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.partition.ldif.AbstractLdifPartition;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.exception.LdapOperationException;
import org.apache.directory.shared.ldap.model.ldif.LdifEntry;
import org.apache.directory.shared.ldap.model.ldif.LdifReader;
import org.apache.directory.shared.ldap.model.ldif.LdifUtils;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleFileLdifPartition
extends AbstractLdifPartition {
    private RandomAccessFile ldifFile;
    private volatile boolean enableRewriting = true;
    private boolean dirty = false;
    private Object lock = new Object();
    private static Logger LOG = LoggerFactory.getLogger(SingleFileLdifPartition.class);

    public SingleFileLdifPartition(SchemaManager schemaManager) {
        super(schemaManager);
    }

    @Override
    protected void doInit() throws InvalidNameException, Exception {
        if (!this.initialized) {
            if (this.getPartitionPath() == null) {
                throw new IllegalArgumentException("Partition path cannot be null");
            }
            File partitionFile = new File(this.getPartitionPath());
            if (partitionFile.exists() && !partitionFile.isFile()) {
                throw new IllegalArgumentException("Partition path must be a LDIF file");
            }
            this.ldifFile = new RandomAccessFile(partitionFile, "rws");
            LOG.debug("id is : {}", (Object)this.getId());
            if (this.suffixDn == null || this.suffixDn.isEmpty()) {
                String msg = I18n.err(I18n.ERR_150, new Object[0]);
                LOG.error(msg);
                throw new LdapInvalidDnException(msg);
            }
            if (!this.suffixDn.isSchemaAware()) {
                this.suffixDn.apply(this.schemaManager);
            }
            super.doInit();
            this.loadEntries();
        }
    }

    private void loadEntries() throws Exception {
        RandomAccessLdifReader parser = new RandomAccessLdifReader();
        Iterator<LdifEntry> itr = parser.iterator();
        if (!itr.hasNext()) {
            return;
        }
        LdifEntry ldifEntry = itr.next();
        DefaultEntry contextEntry = new DefaultEntry(this.schemaManager, ldifEntry.getEntry());
        if (this.suffixDn.equals(contextEntry.getDn())) {
            this.addMandatoryOpAt(contextEntry);
            AddOperationContext addContext = new AddOperationContext(null, contextEntry);
            super.add(addContext);
        } else {
            throw new LdapException("The given LDIF file doesn't contain the context entry");
        }
        while (itr.hasNext()) {
            ldifEntry = itr.next();
            DefaultEntry entry = new DefaultEntry(this.schemaManager, ldifEntry.getEntry());
            this.addMandatoryOpAt(entry);
            AddOperationContext addContext = new AddOperationContext(null, entry);
            super.add(addContext);
        }
        parser.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(AddOperationContext addContext) throws LdapException {
        Object object = this.lock;
        synchronized (object) {
            super.add(addContext);
            this.dirty = true;
            this.rewritePartitionData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        Object object = this.lock;
        synchronized (object) {
            try {
                Entry modifiedEntry = super.modify(modifyContext.getDn(), modifyContext.getModItems().toArray(new Modification[0]));
                modifyContext.setAlteredEntry(modifiedEntry);
            }
            catch (Exception e) {
                throw new LdapOperationException(e.getMessage(), e);
            }
            this.dirty = true;
            this.rewritePartitionData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(RenameOperationContext renameContext) throws LdapException {
        Object object = this.lock;
        synchronized (object) {
            super.rename(renameContext);
            this.dirty = true;
            this.rewritePartitionData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(MoveOperationContext moveContext) throws LdapException {
        Object object = this.lock;
        synchronized (object) {
            super.move(moveContext);
            this.dirty = true;
            this.rewritePartitionData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveAndRename(MoveAndRenameOperationContext opContext) throws LdapException {
        Object object = this.lock;
        synchronized (object) {
            super.moveAndRename(opContext);
            this.dirty = true;
            this.rewritePartitionData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Long id) throws LdapException {
        Object object = this.lock;
        synchronized (object) {
            super.delete(id);
            this.dirty = true;
            this.rewritePartitionData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewritePartitionData() throws LdapException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.enableRewriting || !this.dirty) {
                return;
            }
            try {
                this.ldifFile.setLength(0L);
                Long suffixId = (Long)this.getEntryId(this.suffixDn);
                if (suffixId == null) {
                    return;
                }
                IndexCursor cursor = this.getOneLevelIndex().forwardCursor(suffixId);
                this.appendLdif(this.lookup(suffixId));
                while (cursor.next()) {
                    Long childId = (Long)((IndexEntry)cursor.get()).getId();
                    Entry entry = this.lookup(childId);
                    this.appendLdif(entry);
                    this.appendRecursive(childId, null);
                }
                cursor.close();
                this.dirty = false;
            }
            catch (LdapException e) {
                throw e;
            }
            catch (Exception e) {
                throw new LdapException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendRecursive(Long entryId, Map<Long, IndexCursor<Long, Entry, Long>> cursorMap) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            IndexCursor<Long, Entry, Long> cursor = null;
            if (cursorMap == null) {
                cursorMap = new HashMap<Long, IndexCursor<Long, Entry, Long>>();
            }
            if ((cursor = cursorMap.get(entryId)) == null) {
                cursor = this.getOneLevelIndex().forwardCursor(entryId);
                cursor.beforeFirst();
                cursorMap.put(entryId, cursor);
            }
            if (!cursor.next()) {
                cursorMap.remove(entryId);
                cursor.close();
            } else {
                do {
                    IndexEntry idxEntry = (IndexEntry)cursor.get();
                    Entry entry = this.lookup((Comparable)idxEntry.getId());
                    Long childId = (Long)this.getEntryId(entry.getDn());
                    this.appendLdif(entry);
                    this.appendRecursive(childId, cursorMap);
                } while (cursor.next());
                cursorMap.remove(entryId);
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendLdif(Entry entry) throws IOException, LdapException {
        Object object = this.lock;
        synchronized (object) {
            String ldif = LdifUtils.convertToLdif(entry);
            this.ldifFile.write(Strings.getBytesUtf8(ldif + "\n"));
        }
    }

    private void addMandatoryOpAt(Entry entry) throws LdapException {
        if (entry.get("entryCSN") == null) {
            entry.add("entryCSN", defaultCSNFactory.newInstance().toString());
        }
        if (entry.get("entryUUID") == null) {
            String uuid = UUID.randomUUID().toString();
            entry.add("entryUUID", uuid);
        }
    }

    @Override
    protected void doDestroy() throws Exception {
        super.doDestroy();
        this.ldifFile.close();
    }

    public void setEnableRewriting(boolean enableRewriting) throws LdapException {
        this.enableRewriting = enableRewriting;
        this.rewritePartitionData();
    }

    private class RandomAccessLdifReader
    extends LdifReader {
        private long len;

        public RandomAccessLdifReader() throws LdapException {
            try {
                this.len = SingleFileLdifPartition.this.ldifFile.length();
            }
            catch (IOException e) {
                LdapException le = new LdapException(e.getMessage(), e);
                le.initCause(e);
                throw le;
            }
        }

        @Override
        protected String getLine() throws IOException {
            if (this.len == 0L) {
                return null;
            }
            return SingleFileLdifPartition.this.ldifFile.readLine();
        }
    }
}

